<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingChannelCode StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides information on whether an item may be displayed and in what order. | Specific code in relation to POS booking source (e.g. Expedia, hotels.com, etc.).
 * @subpackage Structs
 */
class BookingChannelCode extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The RestrictedDisplayIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, used to indicate the rate should not be displayed. When false, indicates the rate may be displayed.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $RestrictedDisplayIndicator;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - documentation: Used to define the display order.
     * - type: xs:nonNegativeInteger
     * - use: optional
     * @var int
     */
    public $Sort;
    /**
     * Constructor method for BookingChannelCode
     * @uses BookingChannelCode::set_()
     * @uses BookingChannelCode::setRestrictedDisplayIndicator()
     * @uses BookingChannelCode::setSort()
     * @param string $_
     * @param bool $restrictedDisplayIndicator
     * @param int $sort
     */
    public function __construct($_ = null, $restrictedDisplayIndicator = null, $sort = null)
    {
        $this
            ->set_($_)
            ->setRestrictedDisplayIndicator($restrictedDisplayIndicator)
            ->setSort($sort);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\BookingChannelCode
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get RestrictedDisplayIndicator value
     * @return bool|null
     */
    public function getRestrictedDisplayIndicator()
    {
        return $this->RestrictedDisplayIndicator;
    }
    /**
     * Set RestrictedDisplayIndicator value
     * @param bool $restrictedDisplayIndicator
     * @return \StructType\BookingChannelCode
     */
    public function setRestrictedDisplayIndicator($restrictedDisplayIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictedDisplayIndicator) && !is_bool($restrictedDisplayIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictedDisplayIndicator, true), gettype($restrictedDisplayIndicator)), __LINE__);
        }
        $this->RestrictedDisplayIndicator = $restrictedDisplayIndicator;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\BookingChannelCode
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingChannelCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
