<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookFlightSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Construct for holding the booked flight segment information. | Container for the flight segment data plus the MarriageGrp.
 * @subpackage Structs
 */
class BookFlightSegmentType extends FlightSegmentType
{
    /**
     * The MarriageGrp
     * Meta information extracted from the WSDL
     * - documentation: Many airlines link connection flights together by terming them married segments. When two or more segments are married, they must be processed as one unit. The segments must be moved, cancelled, and/or priced together. The value of
     * the marriage group must be the same for all segments. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarriageGrp;
    /**
     * The BookingClassAvails
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\BookingClassAvails[]
     */
    public $BookingClassAvails;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Free text information that the marketing carrier may send about this flight.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\FreeTextType[]
     */
    public $Comment;
    /**
     * The StopLocation
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\StopLocation[]
     */
    public $StopLocation;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Specific Booking Class for this segment. | Used for an Alpha String, length 1 to 2 (for letter codes).
     * - base: xs:string
     * - pattern: [A-Z]{1,2}
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The NumberInParty
     * Meta information extracted from the WSDL
     * - documentation: Number of travelers associated with this segment.
     * - use: optional
     * @var int
     */
    public $NumberInParty;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Code providing status information for this segment. Refer to OpenTravel Code List Status (STS). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The E_TicketEligibility
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $E_TicketEligibility;
    /**
     * The MealCode
     * Meta information extracted from the WSDL
     * - documentation: The applicable meal service code for this flight.
     * - use: optional
     * @var string
     */
    public $MealCode;
    /**
     * The DepartureDay
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DepartureDay;
    /**
     * The StopoverInd
     * Meta information extracted from the WSDL
     * - documentation: When true a stopover is permitted (airline display "O"). When false a stopover is not permitted (airline display "X").
     * - use: optional
     * @var bool
     */
    public $StopoverInd;
    /**
     * The LineNumber
     * Meta information extracted from the WSDL
     * - documentation: A number that corresponds to a line in a previous response of flight segments. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $LineNumber;
    /**
     * The ConnectionType
     * Meta information extracted from the WSDL
     * - documentation: Used to provide the type of connection for this flight segment. | Used for Character Strings, length 0 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $ConnectionType;
    /**
     * The ParticipationLevelCode
     * Meta information extracted from the WSDL
     * - documentation: To specify the level of participation by a vendor in another system. Refer to OpenTravel Code List Participation Level Code (PLC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP,
     * or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $ParticipationLevelCode;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - documentation: Miles acquired per flight segment, usually used for earning of frequent flyer miles.
     * - use: optional
     * @var int
     */
    public $Distance;
    /**
     * The DateChangeNbr
     * Meta information extracted from the WSDL
     * - documentation: The number of days by which the flight's arrival date differs from its departure date (e.g., +1, -1).
     * - use: optional
     * @var string
     */
    public $DateChangeNbr;
    /**
     * The ValidConnectionInd
     * Meta information extracted from the WSDL
     * - documentation: When true, this flight segment constitutes a valid connection.
     * - use: optional
     * @var bool
     */
    public $ValidConnectionInd;
    /**
     * Constructor method for BookFlightSegmentType
     * @uses BookFlightSegmentType::setMarriageGrp()
     * @uses BookFlightSegmentType::setBookingClassAvails()
     * @uses BookFlightSegmentType::setComment()
     * @uses BookFlightSegmentType::setStopLocation()
     * @uses BookFlightSegmentType::setResBookDesigCode()
     * @uses BookFlightSegmentType::setNumberInParty()
     * @uses BookFlightSegmentType::setStatus()
     * @uses BookFlightSegmentType::setE_TicketEligibility()
     * @uses BookFlightSegmentType::setMealCode()
     * @uses BookFlightSegmentType::setDepartureDay()
     * @uses BookFlightSegmentType::setStopoverInd()
     * @uses BookFlightSegmentType::setLineNumber()
     * @uses BookFlightSegmentType::setConnectionType()
     * @uses BookFlightSegmentType::setParticipationLevelCode()
     * @uses BookFlightSegmentType::setDistance()
     * @uses BookFlightSegmentType::setDateChangeNbr()
     * @uses BookFlightSegmentType::setValidConnectionInd()
     * @param string $marriageGrp
     * @param \StructType\BookingClassAvails[] $bookingClassAvails
     * @param \StructType\FreeTextType[] $comment
     * @param \StructType\StopLocation[] $stopLocation
     * @param string $resBookDesigCode
     * @param int $numberInParty
     * @param string $status
     * @param string $e_TicketEligibility
     * @param string $mealCode
     * @param string $departureDay
     * @param bool $stopoverInd
     * @param int $lineNumber
     * @param string $connectionType
     * @param string $participationLevelCode
     * @param int $distance
     * @param string $dateChangeNbr
     * @param bool $validConnectionInd
     */
    public function __construct($marriageGrp = null, array $bookingClassAvails = array(), array $comment = array(), array $stopLocation = array(), $resBookDesigCode = null, $numberInParty = null, $status = null, $e_TicketEligibility = null, $mealCode = null, $departureDay = null, $stopoverInd = null, $lineNumber = null, $connectionType = null, $participationLevelCode = null, $distance = null, $dateChangeNbr = null, $validConnectionInd = null)
    {
        $this
            ->setMarriageGrp($marriageGrp)
            ->setBookingClassAvails($bookingClassAvails)
            ->setComment($comment)
            ->setStopLocation($stopLocation)
            ->setResBookDesigCode($resBookDesigCode)
            ->setNumberInParty($numberInParty)
            ->setStatus($status)
            ->setE_TicketEligibility($e_TicketEligibility)
            ->setMealCode($mealCode)
            ->setDepartureDay($departureDay)
            ->setStopoverInd($stopoverInd)
            ->setLineNumber($lineNumber)
            ->setConnectionType($connectionType)
            ->setParticipationLevelCode($participationLevelCode)
            ->setDistance($distance)
            ->setDateChangeNbr($dateChangeNbr)
            ->setValidConnectionInd($validConnectionInd);
    }
    /**
     * Get MarriageGrp value
     * @return string|null
     */
    public function getMarriageGrp()
    {
        return $this->MarriageGrp;
    }
    /**
     * Set MarriageGrp value
     * @param string $marriageGrp
     * @return \StructType\BookFlightSegmentType
     */
    public function setMarriageGrp($marriageGrp = null)
    {
        // validation for constraint: string
        if (!is_null($marriageGrp) && !is_string($marriageGrp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marriageGrp, true), gettype($marriageGrp)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($marriageGrp) && mb_strlen($marriageGrp) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($marriageGrp)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($marriageGrp) && mb_strlen($marriageGrp) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($marriageGrp)), __LINE__);
        }
        $this->MarriageGrp = $marriageGrp;
        return $this;
    }
    /**
     * Get BookingClassAvails value
     * @return \StructType\BookingClassAvails[]|null
     */
    public function getBookingClassAvails()
    {
        return $this->BookingClassAvails;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingClassAvails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingClassAvails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingClassAvailsForArrayConstraintsFromSetBookingClassAvails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookFlightSegmentTypeBookingClassAvailsItem) {
            // validation for constraint: itemType
            if (!$bookFlightSegmentTypeBookingClassAvailsItem instanceof \StructType\BookingClassAvails) {
                $invalidValues[] = is_object($bookFlightSegmentTypeBookingClassAvailsItem) ? get_class($bookFlightSegmentTypeBookingClassAvailsItem) : sprintf('%s(%s)', gettype($bookFlightSegmentTypeBookingClassAvailsItem), var_export($bookFlightSegmentTypeBookingClassAvailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingClassAvails property can only contain items of type \StructType\BookingClassAvails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingClassAvails value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingClassAvails[] $bookingClassAvails
     * @return \StructType\BookFlightSegmentType
     */
    public function setBookingClassAvails(array $bookingClassAvails = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingClassAvailsArrayErrorMessage = self::validateBookingClassAvailsForArrayConstraintsFromSetBookingClassAvails($bookingClassAvails))) {
            throw new \InvalidArgumentException($bookingClassAvailsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($bookingClassAvails) && count($bookingClassAvails) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($bookingClassAvails)), __LINE__);
        }
        $this->BookingClassAvails = $bookingClassAvails;
        return $this;
    }
    /**
     * Add item to BookingClassAvails value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingClassAvails $item
     * @return \StructType\BookFlightSegmentType
     */
    public function addToBookingClassAvails(\StructType\BookingClassAvails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingClassAvails) {
            throw new \InvalidArgumentException(sprintf('The BookingClassAvails property can only contain items of type \StructType\BookingClassAvails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->BookingClassAvails) && count($this->BookingClassAvails) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->BookingClassAvails)), __LINE__);
        }
        $this->BookingClassAvails[] = $item;
        return $this;
    }
    /**
     * Get Comment value
     * @return \StructType\FreeTextType[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * This method is responsible for validating the values passed to the setComment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommentForArrayConstraintsFromSetComment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookFlightSegmentTypeCommentItem) {
            // validation for constraint: itemType
            if (!$bookFlightSegmentTypeCommentItem instanceof \StructType\FreeTextType) {
                $invalidValues[] = is_object($bookFlightSegmentTypeCommentItem) ? get_class($bookFlightSegmentTypeCommentItem) : sprintf('%s(%s)', gettype($bookFlightSegmentTypeCommentItem), var_export($bookFlightSegmentTypeCommentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Comment property can only contain items of type \StructType\FreeTextType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType[] $comment
     * @return \StructType\BookFlightSegmentType
     */
    public function setComment(array $comment = array())
    {
        // validation for constraint: array
        if ('' !== ($commentArrayErrorMessage = self::validateCommentForArrayConstraintsFromSetComment($comment))) {
            throw new \InvalidArgumentException($commentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($comment) && count($comment) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\FreeTextType $item
     * @return \StructType\BookFlightSegmentType
     */
    public function addToComment(\StructType\FreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FreeTextType) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of type \StructType\FreeTextType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Comment) && count($this->Comment) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Comment)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Get StopLocation value
     * @return \StructType\StopLocation[]|null
     */
    public function getStopLocation()
    {
        return $this->StopLocation;
    }
    /**
     * This method is responsible for validating the values passed to the setStopLocation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStopLocation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStopLocationForArrayConstraintsFromSetStopLocation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookFlightSegmentTypeStopLocationItem) {
            // validation for constraint: itemType
            if (!$bookFlightSegmentTypeStopLocationItem instanceof \StructType\StopLocation) {
                $invalidValues[] = is_object($bookFlightSegmentTypeStopLocationItem) ? get_class($bookFlightSegmentTypeStopLocationItem) : sprintf('%s(%s)', gettype($bookFlightSegmentTypeStopLocationItem), var_export($bookFlightSegmentTypeStopLocationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StopLocation property can only contain items of type \StructType\StopLocation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StopLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\StopLocation[] $stopLocation
     * @return \StructType\BookFlightSegmentType
     */
    public function setStopLocation(array $stopLocation = array())
    {
        // validation for constraint: array
        if ('' !== ($stopLocationArrayErrorMessage = self::validateStopLocationForArrayConstraintsFromSetStopLocation($stopLocation))) {
            throw new \InvalidArgumentException($stopLocationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($stopLocation) && count($stopLocation) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($stopLocation)), __LINE__);
        }
        $this->StopLocation = $stopLocation;
        return $this;
    }
    /**
     * Add item to StopLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\StopLocation $item
     * @return \StructType\BookFlightSegmentType
     */
    public function addToStopLocation(\StructType\StopLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StopLocation) {
            throw new \InvalidArgumentException(sprintf('The StopLocation property can only contain items of type \StructType\StopLocation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->StopLocation) && count($this->StopLocation) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->StopLocation)), __LINE__);
        }
        $this->StopLocation[] = $item;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\BookFlightSegmentType
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{1,2})
        if (!is_null($resBookDesigCode) && !preg_match('/[A-Z]{1,2}/', $resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{1,2}', var_export($resBookDesigCode, true)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return int|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param int $numberInParty
     * @return \StructType\BookFlightSegmentType
     */
    public function setNumberInParty($numberInParty = null)
    {
        // validation for constraint: int
        if (!is_null($numberInParty) && !(is_int($numberInParty) || ctype_digit($numberInParty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberInParty, true), gettype($numberInParty)), __LINE__);
        }
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\BookFlightSegmentType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($status) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($status, true)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get E_TicketEligibility value
     * @return string|null
     */
    public function getE_TicketEligibility()
    {
        return $this->E_TicketEligibility;
    }
    /**
     * Set E_TicketEligibility value
     * @param string $e_TicketEligibility
     * @return \StructType\BookFlightSegmentType
     */
    public function setE_TicketEligibility($e_TicketEligibility = null)
    {
        // validation for constraint: string
        if (!is_null($e_TicketEligibility) && !is_string($e_TicketEligibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($e_TicketEligibility, true), gettype($e_TicketEligibility)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($e_TicketEligibility) && mb_strlen($e_TicketEligibility) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($e_TicketEligibility)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($e_TicketEligibility) && mb_strlen($e_TicketEligibility) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($e_TicketEligibility)), __LINE__);
        }
        $this->E_TicketEligibility = $e_TicketEligibility;
        return $this;
    }
    /**
     * Get MealCode value
     * @return string|null
     */
    public function getMealCode()
    {
        return $this->MealCode;
    }
    /**
     * Set MealCode value
     * @uses \EnumType\MealServiceType::valueIsValid()
     * @uses \EnumType\MealServiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mealCode
     * @return \StructType\BookFlightSegmentType
     */
    public function setMealCode($mealCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MealServiceType::valueIsValid($mealCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MealServiceType', is_array($mealCode) ? implode(', ', $mealCode) : var_export($mealCode, true), implode(', ', \EnumType\MealServiceType::getValidValues())), __LINE__);
        }
        $this->MealCode = $mealCode;
        return $this;
    }
    /**
     * Get DepartureDay value
     * @return string|null
     */
    public function getDepartureDay()
    {
        return $this->DepartureDay;
    }
    /**
     * Set DepartureDay value
     * @uses \EnumType\DayOfWeekType::valueIsValid()
     * @uses \EnumType\DayOfWeekType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departureDay
     * @return \StructType\BookFlightSegmentType
     */
    public function setDepartureDay($departureDay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeekType::valueIsValid($departureDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DayOfWeekType', is_array($departureDay) ? implode(', ', $departureDay) : var_export($departureDay, true), implode(', ', \EnumType\DayOfWeekType::getValidValues())), __LINE__);
        }
        $this->DepartureDay = $departureDay;
        return $this;
    }
    /**
     * Get StopoverInd value
     * @return bool|null
     */
    public function getStopoverInd()
    {
        return $this->StopoverInd;
    }
    /**
     * Set StopoverInd value
     * @param bool $stopoverInd
     * @return \StructType\BookFlightSegmentType
     */
    public function setStopoverInd($stopoverInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($stopoverInd) && !is_bool($stopoverInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stopoverInd, true), gettype($stopoverInd)), __LINE__);
        }
        $this->StopoverInd = $stopoverInd;
        return $this;
    }
    /**
     * Get LineNumber value
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param int $lineNumber
     * @return \StructType\BookFlightSegmentType
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !(is_int($lineNumber) || ctype_digit($lineNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNumber, true), gettype($lineNumber)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($lineNumber) && $lineNumber > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($lineNumber, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($lineNumber) && $lineNumber < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($lineNumber, true)), __LINE__);
        }
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get ConnectionType value
     * @return string|null
     */
    public function getConnectionType()
    {
        return $this->ConnectionType;
    }
    /**
     * Set ConnectionType value
     * @param string $connectionType
     * @return \StructType\BookFlightSegmentType
     */
    public function setConnectionType($connectionType = null)
    {
        // validation for constraint: string
        if (!is_null($connectionType) && !is_string($connectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionType, true), gettype($connectionType)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($connectionType) && mb_strlen($connectionType) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($connectionType)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($connectionType) && mb_strlen($connectionType) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($connectionType)), __LINE__);
        }
        $this->ConnectionType = $connectionType;
        return $this;
    }
    /**
     * Get ParticipationLevelCode value
     * @return string|null
     */
    public function getParticipationLevelCode()
    {
        return $this->ParticipationLevelCode;
    }
    /**
     * Set ParticipationLevelCode value
     * @param string $participationLevelCode
     * @return \StructType\BookFlightSegmentType
     */
    public function setParticipationLevelCode($participationLevelCode = null)
    {
        // validation for constraint: string
        if (!is_null($participationLevelCode) && !is_string($participationLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($participationLevelCode, true), gettype($participationLevelCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($participationLevelCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $participationLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($participationLevelCode, true)), __LINE__);
        }
        $this->ParticipationLevelCode = $participationLevelCode;
        return $this;
    }
    /**
     * Get Distance value
     * @return int|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \StructType\BookFlightSegmentType
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !(is_int($distance) || ctype_digit($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get DateChangeNbr value
     * @return string|null
     */
    public function getDateChangeNbr()
    {
        return $this->DateChangeNbr;
    }
    /**
     * Set DateChangeNbr value
     * @param string $dateChangeNbr
     * @return \StructType\BookFlightSegmentType
     */
    public function setDateChangeNbr($dateChangeNbr = null)
    {
        // validation for constraint: string
        if (!is_null($dateChangeNbr) && !is_string($dateChangeNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateChangeNbr, true), gettype($dateChangeNbr)), __LINE__);
        }
        $this->DateChangeNbr = $dateChangeNbr;
        return $this;
    }
    /**
     * Get ValidConnectionInd value
     * @return bool|null
     */
    public function getValidConnectionInd()
    {
        return $this->ValidConnectionInd;
    }
    /**
     * Set ValidConnectionInd value
     * @param bool $validConnectionInd
     * @return \StructType\BookFlightSegmentType
     */
    public function setValidConnectionInd($validConnectionInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($validConnectionInd) && !is_bool($validConnectionInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validConnectionInd, true), gettype($validConnectionInd)), __LINE__);
        }
        $this->ValidConnectionInd = $validConnectionInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookFlightSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
