<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BlockDescriptions StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of free form information about the inventory block.
 * @subpackage Structs
 */
class BlockDescriptions extends AbstractStructBase
{
    /**
     * The BlockDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\BlockDescription[]
     */
    public $BlockDescription;
    /**
     * Constructor method for BlockDescriptions
     * @uses BlockDescriptions::setBlockDescription()
     * @param \StructType\BlockDescription[] $blockDescription
     */
    public function __construct(array $blockDescription = array())
    {
        $this
            ->setBlockDescription($blockDescription);
    }
    /**
     * Get BlockDescription value
     * @return \StructType\BlockDescription[]|null
     */
    public function getBlockDescription()
    {
        return $this->BlockDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setBlockDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBlockDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBlockDescriptionForArrayConstraintsFromSetBlockDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $blockDescriptionsBlockDescriptionItem) {
            // validation for constraint: itemType
            if (!$blockDescriptionsBlockDescriptionItem instanceof \StructType\BlockDescription) {
                $invalidValues[] = is_object($blockDescriptionsBlockDescriptionItem) ? get_class($blockDescriptionsBlockDescriptionItem) : sprintf('%s(%s)', gettype($blockDescriptionsBlockDescriptionItem), var_export($blockDescriptionsBlockDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BlockDescription property can only contain items of type \StructType\BlockDescription, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BlockDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\BlockDescription[] $blockDescription
     * @return \StructType\BlockDescriptions
     */
    public function setBlockDescription(array $blockDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($blockDescriptionArrayErrorMessage = self::validateBlockDescriptionForArrayConstraintsFromSetBlockDescription($blockDescription))) {
            throw new \InvalidArgumentException($blockDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($blockDescription) && count($blockDescription) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($blockDescription)), __LINE__);
        }
        $this->BlockDescription = $blockDescription;
        return $this;
    }
    /**
     * Add item to BlockDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\BlockDescription $item
     * @return \StructType\BlockDescriptions
     */
    public function addToBlockDescription(\StructType\BlockDescription $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BlockDescription) {
            throw new \InvalidArgumentException(sprintf('The BlockDescription property can only contain items of type \StructType\BlockDescription, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->BlockDescription) && count($this->BlockDescription) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->BlockDescription)), __LINE__);
        }
        $this->BlockDescription[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BlockDescriptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
