<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankAcctType StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows for control of the sharing of bank account information between parties. | Customer bank accounts for payments, either for paper checks or electronic funds transfer.
 * @subpackage Structs
 */
class BankAcctType extends AbstractStructBase
{
    /**
     * The BankAcctName
     * Meta information extracted from the WSDL
     * - documentation: The name the account is held under. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAcctName;
    /**
     * The BankID
     * Meta information extracted from the WSDL
     * - documentation: Code assigned by authorities to financial institutions; sometimes called bank routing number. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $BankID;
    /**
     * The AcctType
     * Meta information extracted from the WSDL
     * - documentation: Describes the bank account used for financing travel (e.g., checking, savings, investment). | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AcctType;
    /**
     * The BankAcctNumber
     * Meta information extracted from the WSDL
     * - documentation: Identifier for the account assigned by the bank. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $BankAcctNumber;
    /**
     * The ChecksAcceptedInd
     * Meta information extracted from the WSDL
     * - documentation: If true, checks are accepted. If false, checks are not accepted.
     * - use: optional
     * @var bool
     */
    public $ChecksAcceptedInd;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * Constructor method for BankAcctType
     * @uses BankAcctType::setBankAcctName()
     * @uses BankAcctType::setBankID()
     * @uses BankAcctType::setAcctType()
     * @uses BankAcctType::setBankAcctNumber()
     * @uses BankAcctType::setChecksAcceptedInd()
     * @uses BankAcctType::setShareSynchInd()
     * @uses BankAcctType::setShareMarketInd()
     * @param string $bankAcctName
     * @param string $bankID
     * @param string $acctType
     * @param string $bankAcctNumber
     * @param bool $checksAcceptedInd
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     */
    public function __construct($bankAcctName = null, $bankID = null, $acctType = null, $bankAcctNumber = null, $checksAcceptedInd = null, $shareSynchInd = null, $shareMarketInd = null)
    {
        $this
            ->setBankAcctName($bankAcctName)
            ->setBankID($bankID)
            ->setAcctType($acctType)
            ->setBankAcctNumber($bankAcctNumber)
            ->setChecksAcceptedInd($checksAcceptedInd)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd);
    }
    /**
     * Get BankAcctName value
     * @return string|null
     */
    public function getBankAcctName()
    {
        return $this->BankAcctName;
    }
    /**
     * Set BankAcctName value
     * @param string $bankAcctName
     * @return \StructType\BankAcctType
     */
    public function setBankAcctName($bankAcctName = null)
    {
        // validation for constraint: string
        if (!is_null($bankAcctName) && !is_string($bankAcctName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAcctName, true), gettype($bankAcctName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bankAcctName) && mb_strlen($bankAcctName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($bankAcctName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankAcctName) && mb_strlen($bankAcctName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankAcctName)), __LINE__);
        }
        $this->BankAcctName = $bankAcctName;
        return $this;
    }
    /**
     * Get BankID value
     * @return string|null
     */
    public function getBankID()
    {
        return $this->BankID;
    }
    /**
     * Set BankID value
     * @param string $bankID
     * @return \StructType\BankAcctType
     */
    public function setBankID($bankID = null)
    {
        // validation for constraint: string
        if (!is_null($bankID) && !is_string($bankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankID, true), gettype($bankID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bankID) && mb_strlen($bankID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($bankID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankID) && mb_strlen($bankID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankID)), __LINE__);
        }
        $this->BankID = $bankID;
        return $this;
    }
    /**
     * Get AcctType value
     * @return string|null
     */
    public function getAcctType()
    {
        return $this->AcctType;
    }
    /**
     * Set AcctType value
     * @param string $acctType
     * @return \StructType\BankAcctType
     */
    public function setAcctType($acctType = null)
    {
        // validation for constraint: string
        if (!is_null($acctType) && !is_string($acctType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acctType, true), gettype($acctType)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($acctType) && mb_strlen($acctType) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($acctType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($acctType) && mb_strlen($acctType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($acctType)), __LINE__);
        }
        $this->AcctType = $acctType;
        return $this;
    }
    /**
     * Get BankAcctNumber value
     * @return string|null
     */
    public function getBankAcctNumber()
    {
        return $this->BankAcctNumber;
    }
    /**
     * Set BankAcctNumber value
     * @param string $bankAcctNumber
     * @return \StructType\BankAcctType
     */
    public function setBankAcctNumber($bankAcctNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bankAcctNumber) && !is_string($bankAcctNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAcctNumber, true), gettype($bankAcctNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($bankAcctNumber) && mb_strlen($bankAcctNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($bankAcctNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($bankAcctNumber) && mb_strlen($bankAcctNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($bankAcctNumber)), __LINE__);
        }
        $this->BankAcctNumber = $bankAcctNumber;
        return $this;
    }
    /**
     * Get ChecksAcceptedInd value
     * @return bool|null
     */
    public function getChecksAcceptedInd()
    {
        return $this->ChecksAcceptedInd;
    }
    /**
     * Set ChecksAcceptedInd value
     * @param bool $checksAcceptedInd
     * @return \StructType\BankAcctType
     */
    public function setChecksAcceptedInd($checksAcceptedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($checksAcceptedInd) && !is_bool($checksAcceptedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checksAcceptedInd, true), gettype($checksAcceptedInd)), __LINE__);
        }
        $this->ChecksAcceptedInd = $checksAcceptedInd;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\BankAcctType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\BankAcctType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankAcctType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
