<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailableCapacities StructType
 * Meta information extracted from the WSDL
 * - documentation: The amount of usable meeting space available at a property.
 * @subpackage Structs
 */
class AvailableCapacities extends AbstractStructBase
{
    /**
     * The MeetingRoomCapacity
     * Meta information extracted from the WSDL
     * - documentation: The measureable dimensions and capacities of a meeting room.
     * - maxOccurs: unbounded
     * @var \StructType\MeetingRoomCapacityType[]
     */
    public $MeetingRoomCapacity;
    /**
     * Constructor method for AvailableCapacities
     * @uses AvailableCapacities::setMeetingRoomCapacity()
     * @param \StructType\MeetingRoomCapacityType[] $meetingRoomCapacity
     */
    public function __construct(array $meetingRoomCapacity = array())
    {
        $this
            ->setMeetingRoomCapacity($meetingRoomCapacity);
    }
    /**
     * Get MeetingRoomCapacity value
     * @return \StructType\MeetingRoomCapacityType[]|null
     */
    public function getMeetingRoomCapacity()
    {
        return $this->MeetingRoomCapacity;
    }
    /**
     * This method is responsible for validating the values passed to the setMeetingRoomCapacity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeetingRoomCapacity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeetingRoomCapacityForArrayConstraintsFromSetMeetingRoomCapacity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $availableCapacitiesMeetingRoomCapacityItem) {
            // validation for constraint: itemType
            if (!$availableCapacitiesMeetingRoomCapacityItem instanceof \StructType\MeetingRoomCapacityType) {
                $invalidValues[] = is_object($availableCapacitiesMeetingRoomCapacityItem) ? get_class($availableCapacitiesMeetingRoomCapacityItem) : sprintf('%s(%s)', gettype($availableCapacitiesMeetingRoomCapacityItem), var_export($availableCapacitiesMeetingRoomCapacityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MeetingRoomCapacity property can only contain items of type \StructType\MeetingRoomCapacityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MeetingRoomCapacity value
     * @throws \InvalidArgumentException
     * @param \StructType\MeetingRoomCapacityType[] $meetingRoomCapacity
     * @return \StructType\AvailableCapacities
     */
    public function setMeetingRoomCapacity(array $meetingRoomCapacity = array())
    {
        // validation for constraint: array
        if ('' !== ($meetingRoomCapacityArrayErrorMessage = self::validateMeetingRoomCapacityForArrayConstraintsFromSetMeetingRoomCapacity($meetingRoomCapacity))) {
            throw new \InvalidArgumentException($meetingRoomCapacityArrayErrorMessage, __LINE__);
        }
        $this->MeetingRoomCapacity = $meetingRoomCapacity;
        return $this;
    }
    /**
     * Add item to MeetingRoomCapacity value
     * @throws \InvalidArgumentException
     * @param \StructType\MeetingRoomCapacityType $item
     * @return \StructType\AvailableCapacities
     */
    public function addToMeetingRoomCapacity(\StructType\MeetingRoomCapacityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MeetingRoomCapacityType) {
            throw new \InvalidArgumentException(sprintf('The MeetingRoomCapacity property can only contain items of type \StructType\MeetingRoomCapacityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MeetingRoomCapacity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailableCapacities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
