<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailRequestSegment StructType
 * Meta information extracted from the WSDL
 * - documentation: To accommodate the ability to perform multiple requests within one message, the availability request contains the repeating element, AvailRequestSegment. Each segment includes a collection of criteria that requests a bookable entity,
 * which may include designated rate plans, room types, amenities or services, and the request can be used for guest rooms or other inventory items for which availability is sought. Each segment would be presumed to have a unique date range for each
 * request.
 * @subpackage Structs
 */
class AvailRequestSegment extends AbstractStructBase
{
    /**
     * The StayDateRange
     * Meta information extracted from the WSDL
     * - documentation: Range of dates, or fixed set of dates for Availability Request. Date range can also be specified by using start dates and number of nights (minimum, maximum or fixed). **This element is maintained at this level to support those who
     * have implemented this message prior to 2005B. For new implementations consider using this element under HotelSearchCriteria.**
     * - minOccurs: 0
     * @var \StructType\DateTimeSpanType
     */
    public $StayDateRange;
    /**
     * The RateRange
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\RateRange[]
     */
    public $RateRange;
    /**
     * The RatePlanCandidates
     * Meta information extracted from the WSDL
     * - documentation: **This element is maintained at this level to support those who have implemented this message prior to 2005B. For new implementations consider using this element under HotelSearchCriteria.**
     * - minOccurs: 0
     * @var \StructType\RatePlanCandidatesType
     */
    public $RatePlanCandidates;
    /**
     * The Profiles
     * Meta information extracted from the WSDL
     * - documentation: A collection of profile objects or unique IDs of profiles. **This element is maintained at this level to support those who have implemented this message prior to 2005B. For new implementations consider using this element under
     * HotelSearchCriteria.**
     * - minOccurs: 0
     * @var \StructType\ProfilesType
     */
    public $Profiles;
    /**
     * The RoomStayCandidates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RoomStayCandidates
     */
    public $RoomStayCandidates;
    /**
     * The HotelSearchCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\HotelSearchCriteria
     */
    public $HotelSearchCriteria;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The AvailReqType
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $AvailReqType;
    /**
     * The MoreDataEchoToken
     * Meta information extracted from the WSDL
     * - documentation: The availability response returns the attribute if there were additional rates that could not fit within the availability response. The text value should be echoed in this availability request to indicate where to begin the next
     * block of availability data. | Used for Character Strings, length 1 to 128.
     * - base: xs:string
     * - maxLength: 128
     * - minLength: 1
     * @var string
     */
    public $MoreDataEchoToken;
    /**
     * The InfoSource
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the source of the data being exchanged as determined by trading partners. | Used to specify the source of the data being exchanged.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $InfoSource;
    /**
     * The ResponseType
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $ResponseType;
    /**
     * Constructor method for AvailRequestSegment
     * @uses AvailRequestSegment::setStayDateRange()
     * @uses AvailRequestSegment::setRateRange()
     * @uses AvailRequestSegment::setRatePlanCandidates()
     * @uses AvailRequestSegment::setProfiles()
     * @uses AvailRequestSegment::setRoomStayCandidates()
     * @uses AvailRequestSegment::setHotelSearchCriteria()
     * @uses AvailRequestSegment::setTPA_Extensions()
     * @uses AvailRequestSegment::setAvailReqType()
     * @uses AvailRequestSegment::setMoreDataEchoToken()
     * @uses AvailRequestSegment::setInfoSource()
     * @uses AvailRequestSegment::setResponseType()
     * @param \StructType\DateTimeSpanType $stayDateRange
     * @param \StructType\RateRange[] $rateRange
     * @param \StructType\RatePlanCandidatesType $ratePlanCandidates
     * @param \StructType\ProfilesType $profiles
     * @param \StructType\RoomStayCandidates $roomStayCandidates
     * @param \StructType\HotelSearchCriteria $hotelSearchCriteria
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param string $availReqType
     * @param string $moreDataEchoToken
     * @param string $infoSource
     * @param string $responseType
     */
    public function __construct(\StructType\DateTimeSpanType $stayDateRange = null, array $rateRange = array(), \StructType\RatePlanCandidatesType $ratePlanCandidates = null, \StructType\ProfilesType $profiles = null, \StructType\RoomStayCandidates $roomStayCandidates = null, \StructType\HotelSearchCriteria $hotelSearchCriteria = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $availReqType = null, $moreDataEchoToken = null, $infoSource = null, $responseType = null)
    {
        $this
            ->setStayDateRange($stayDateRange)
            ->setRateRange($rateRange)
            ->setRatePlanCandidates($ratePlanCandidates)
            ->setProfiles($profiles)
            ->setRoomStayCandidates($roomStayCandidates)
            ->setHotelSearchCriteria($hotelSearchCriteria)
            ->setTPA_Extensions($tPA_Extensions)
            ->setAvailReqType($availReqType)
            ->setMoreDataEchoToken($moreDataEchoToken)
            ->setInfoSource($infoSource)
            ->setResponseType($responseType);
    }
    /**
     * Get StayDateRange value
     * @return \StructType\DateTimeSpanType|null
     */
    public function getStayDateRange()
    {
        return $this->StayDateRange;
    }
    /**
     * Set StayDateRange value
     * @param \StructType\DateTimeSpanType $stayDateRange
     * @return \StructType\AvailRequestSegment
     */
    public function setStayDateRange(\StructType\DateTimeSpanType $stayDateRange = null)
    {
        $this->StayDateRange = $stayDateRange;
        return $this;
    }
    /**
     * Get RateRange value
     * @return \StructType\RateRange[]|null
     */
    public function getRateRange()
    {
        return $this->RateRange;
    }
    /**
     * This method is responsible for validating the values passed to the setRateRange method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRateRange method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateRangeForArrayConstraintsFromSetRateRange(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $availRequestSegmentRateRangeItem) {
            // validation for constraint: itemType
            if (!$availRequestSegmentRateRangeItem instanceof \StructType\RateRange) {
                $invalidValues[] = is_object($availRequestSegmentRateRangeItem) ? get_class($availRequestSegmentRateRangeItem) : sprintf('%s(%s)', gettype($availRequestSegmentRateRangeItem), var_export($availRequestSegmentRateRangeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RateRange property can only contain items of type \StructType\RateRange, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RateRange value
     * @throws \InvalidArgumentException
     * @param \StructType\RateRange[] $rateRange
     * @return \StructType\AvailRequestSegment
     */
    public function setRateRange(array $rateRange = array())
    {
        // validation for constraint: array
        if ('' !== ($rateRangeArrayErrorMessage = self::validateRateRangeForArrayConstraintsFromSetRateRange($rateRange))) {
            throw new \InvalidArgumentException($rateRangeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($rateRange) && count($rateRange) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($rateRange)), __LINE__);
        }
        $this->RateRange = $rateRange;
        return $this;
    }
    /**
     * Add item to RateRange value
     * @throws \InvalidArgumentException
     * @param \StructType\RateRange $item
     * @return \StructType\AvailRequestSegment
     */
    public function addToRateRange(\StructType\RateRange $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateRange) {
            throw new \InvalidArgumentException(sprintf('The RateRange property can only contain items of type \StructType\RateRange, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->RateRange) && count($this->RateRange) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->RateRange)), __LINE__);
        }
        $this->RateRange[] = $item;
        return $this;
    }
    /**
     * Get RatePlanCandidates value
     * @return \StructType\RatePlanCandidatesType|null
     */
    public function getRatePlanCandidates()
    {
        return $this->RatePlanCandidates;
    }
    /**
     * Set RatePlanCandidates value
     * @param \StructType\RatePlanCandidatesType $ratePlanCandidates
     * @return \StructType\AvailRequestSegment
     */
    public function setRatePlanCandidates(\StructType\RatePlanCandidatesType $ratePlanCandidates = null)
    {
        $this->RatePlanCandidates = $ratePlanCandidates;
        return $this;
    }
    /**
     * Get Profiles value
     * @return \StructType\ProfilesType|null
     */
    public function getProfiles()
    {
        return $this->Profiles;
    }
    /**
     * Set Profiles value
     * @param \StructType\ProfilesType $profiles
     * @return \StructType\AvailRequestSegment
     */
    public function setProfiles(\StructType\ProfilesType $profiles = null)
    {
        $this->Profiles = $profiles;
        return $this;
    }
    /**
     * Get RoomStayCandidates value
     * @return \StructType\RoomStayCandidates|null
     */
    public function getRoomStayCandidates()
    {
        return $this->RoomStayCandidates;
    }
    /**
     * Set RoomStayCandidates value
     * @param \StructType\RoomStayCandidates $roomStayCandidates
     * @return \StructType\AvailRequestSegment
     */
    public function setRoomStayCandidates(\StructType\RoomStayCandidates $roomStayCandidates = null)
    {
        $this->RoomStayCandidates = $roomStayCandidates;
        return $this;
    }
    /**
     * Get HotelSearchCriteria value
     * @return \StructType\HotelSearchCriteria|null
     */
    public function getHotelSearchCriteria()
    {
        return $this->HotelSearchCriteria;
    }
    /**
     * Set HotelSearchCriteria value
     * @param \StructType\HotelSearchCriteria $hotelSearchCriteria
     * @return \StructType\AvailRequestSegment
     */
    public function setHotelSearchCriteria(\StructType\HotelSearchCriteria $hotelSearchCriteria = null)
    {
        $this->HotelSearchCriteria = $hotelSearchCriteria;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\AvailRequestSegment
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get AvailReqType value
     * @return string|null
     */
    public function getAvailReqType()
    {
        return $this->AvailReqType;
    }
    /**
     * Set AvailReqType value
     * @param string $availReqType
     * @return \StructType\AvailRequestSegment
     */
    public function setAvailReqType($availReqType = null)
    {
        // validation for constraint: string
        if (!is_null($availReqType) && !is_string($availReqType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availReqType, true), gettype($availReqType)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($availReqType) && mb_strlen($availReqType) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($availReqType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($availReqType) && mb_strlen($availReqType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($availReqType)), __LINE__);
        }
        $this->AvailReqType = $availReqType;
        return $this;
    }
    /**
     * Get MoreDataEchoToken value
     * @return string|null
     */
    public function getMoreDataEchoToken()
    {
        return $this->MoreDataEchoToken;
    }
    /**
     * Set MoreDataEchoToken value
     * @param string $moreDataEchoToken
     * @return \StructType\AvailRequestSegment
     */
    public function setMoreDataEchoToken($moreDataEchoToken = null)
    {
        // validation for constraint: string
        if (!is_null($moreDataEchoToken) && !is_string($moreDataEchoToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($moreDataEchoToken, true), gettype($moreDataEchoToken)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($moreDataEchoToken) && mb_strlen($moreDataEchoToken) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($moreDataEchoToken)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($moreDataEchoToken) && mb_strlen($moreDataEchoToken) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($moreDataEchoToken)), __LINE__);
        }
        $this->MoreDataEchoToken = $moreDataEchoToken;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\AvailRequestSegment
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($infoSource) && mb_strlen($infoSource) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($infoSource)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($infoSource) && mb_strlen($infoSource) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get ResponseType value
     * @return string|null
     */
    public function getResponseType()
    {
        return $this->ResponseType;
    }
    /**
     * Set ResponseType value
     * @param string $responseType
     * @return \StructType\AvailRequestSegment
     */
    public function setResponseType($responseType = null)
    {
        // validation for constraint: string
        if (!is_null($responseType) && !is_string($responseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseType, true), gettype($responseType)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($responseType) && mb_strlen($responseType) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($responseType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($responseType) && mb_strlen($responseType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($responseType)), __LINE__);
        }
        $this->ResponseType = $responseType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AvailRequestSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
