<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizedViewer StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies those authorized to view a confidential special remark. | Specifies those authorized to view a comment.
 * @subpackage Structs
 */
class AuthorizedViewer extends AbstractStructBase
{
    /**
     * The ViewerCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies an authorized viewer of a confidential remark. Can be a 3 character ATA/IATA airport/city code, an office ID, pseudo city code, etc. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ViewerCode;
    /**
     * The ViewerCarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Carrier code that may be used in conjunction with the viewer code to identify those authorized to view the confidential special remark. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ViewerCarrierCode;
    /**
     * Constructor method for AuthorizedViewer
     * @uses AuthorizedViewer::setViewerCode()
     * @uses AuthorizedViewer::setViewerCarrierCode()
     * @param string $viewerCode
     * @param string $viewerCarrierCode
     */
    public function __construct($viewerCode = null, $viewerCarrierCode = null)
    {
        $this
            ->setViewerCode($viewerCode)
            ->setViewerCarrierCode($viewerCarrierCode);
    }
    /**
     * Get ViewerCode value
     * @return string|null
     */
    public function getViewerCode()
    {
        return $this->ViewerCode;
    }
    /**
     * Set ViewerCode value
     * @param string $viewerCode
     * @return \StructType\AuthorizedViewer
     */
    public function setViewerCode($viewerCode = null)
    {
        // validation for constraint: string
        if (!is_null($viewerCode) && !is_string($viewerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewerCode, true), gettype($viewerCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($viewerCode) && mb_strlen($viewerCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($viewerCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($viewerCode) && mb_strlen($viewerCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($viewerCode)), __LINE__);
        }
        $this->ViewerCode = $viewerCode;
        return $this;
    }
    /**
     * Get ViewerCarrierCode value
     * @return string|null
     */
    public function getViewerCarrierCode()
    {
        return $this->ViewerCarrierCode;
    }
    /**
     * Set ViewerCarrierCode value
     * @param string $viewerCarrierCode
     * @return \StructType\AuthorizedViewer
     */
    public function setViewerCarrierCode($viewerCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($viewerCarrierCode) && !is_string($viewerCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewerCarrierCode, true), gettype($viewerCarrierCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($viewerCarrierCode) && mb_strlen($viewerCarrierCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($viewerCarrierCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($viewerCarrierCode) && mb_strlen($viewerCarrierCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($viewerCarrierCode)), __LINE__);
        }
        $this->ViewerCarrierCode = $viewerCarrierCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthorizedViewer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
