<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociatedSupplier StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about the supplier. | The supplier for whom this is the preferred method of payment.
 * @subpackage Structs
 */
class AssociatedSupplier extends AbstractStructBase
{
    /**
     * The CompanyShortName
     * Meta information extracted from the WSDL
     * - documentation: Used to provide the company common name. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $CompanyShortName;
    /**
     * The TravelSector
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Travel Sector (TVS). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $TravelSector;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Identifies a company by the company code. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - type: StringLength1to16
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Identifies the context of the identifying code, such as DUNS, IATA or internal code, etc. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $CodeContext;
    /**
     * Constructor method for AssociatedSupplier
     * @uses AssociatedSupplier::setCompanyShortName()
     * @uses AssociatedSupplier::setTravelSector()
     * @uses AssociatedSupplier::setCode()
     * @uses AssociatedSupplier::setCodeContext()
     * @param string $companyShortName
     * @param string $travelSector
     * @param string $code
     * @param string $codeContext
     */
    public function __construct($companyShortName = null, $travelSector = null, $code = null, $codeContext = null)
    {
        $this
            ->setCompanyShortName($companyShortName)
            ->setTravelSector($travelSector)
            ->setCode($code)
            ->setCodeContext($codeContext);
    }
    /**
     * Get CompanyShortName value
     * @return string|null
     */
    public function getCompanyShortName()
    {
        return $this->CompanyShortName;
    }
    /**
     * Set CompanyShortName value
     * @param string $companyShortName
     * @return \StructType\AssociatedSupplier
     */
    public function setCompanyShortName($companyShortName = null)
    {
        // validation for constraint: string
        if (!is_null($companyShortName) && !is_string($companyShortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyShortName, true), gettype($companyShortName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($companyShortName) && mb_strlen($companyShortName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($companyShortName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($companyShortName) && mb_strlen($companyShortName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($companyShortName)), __LINE__);
        }
        $this->CompanyShortName = $companyShortName;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \StructType\AssociatedSupplier
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travelSector, true), gettype($travelSector)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($travelSector) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($travelSector, true)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\AssociatedSupplier
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($code) && mb_strlen($code) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\AssociatedSupplier
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($codeContext) && mb_strlen($codeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($codeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeContext) && mb_strlen($codeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AssociatedSupplier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
