<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Area StructType
 * Meta information extracted from the WSDL
 * - documentation: An area determined by the hotel reservation system.
 * - type: xs:decimal
 * - use: optional
 * @subpackage Structs
 */
class Area extends AbstractStructBase
{
    /**
     * The AreaDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ParagraphType
     */
    public $AreaDescription;
    /**
     * The CityCode
     * Meta information extracted from the WSDL
     * - documentation: The IATA city code; for example DCA, ORD. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $CityCode;
    /**
     * The StateProvCode
     * Meta information extracted from the WSDL
     * - documentation: The standard code or abbreviation for the state, province, or region. | Used for Character Strings, length 1 to 8.
     * - base: StringLength1to8
     * - maxLength: 8
     * - minLength: 2
     * - use: optional
     * @var string
     */
    public $StateProvCode;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: The country in which the area is located. | Specifies a 2 character country code as defined in ISO3166.
     * - base: xs:string
     * - pattern: [a-zA-Z]{2}
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * The AreaID
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * @var string
     */
    public $AreaID;
    /**
     * Constructor method for Area
     * @uses Area::setAreaDescription()
     * @uses Area::setCityCode()
     * @uses Area::setStateProvCode()
     * @uses Area::setCountryCode()
     * @uses Area::setAreaID()
     * @param \StructType\ParagraphType $areaDescription
     * @param string $cityCode
     * @param string $stateProvCode
     * @param string $countryCode
     * @param string $areaID
     */
    public function __construct(\StructType\ParagraphType $areaDescription = null, $cityCode = null, $stateProvCode = null, $countryCode = null, $areaID = null)
    {
        $this
            ->setAreaDescription($areaDescription)
            ->setCityCode($cityCode)
            ->setStateProvCode($stateProvCode)
            ->setCountryCode($countryCode)
            ->setAreaID($areaID);
    }
    /**
     * Get AreaDescription value
     * @return \StructType\ParagraphType|null
     */
    public function getAreaDescription()
    {
        return $this->AreaDescription;
    }
    /**
     * Set AreaDescription value
     * @param \StructType\ParagraphType $areaDescription
     * @return \StructType\Area
     */
    public function setAreaDescription(\StructType\ParagraphType $areaDescription = null)
    {
        $this->AreaDescription = $areaDescription;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \StructType\Area
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityCode, true), gettype($cityCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($cityCode) && mb_strlen($cityCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($cityCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cityCode) && mb_strlen($cityCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get StateProvCode value
     * @return string|null
     */
    public function getStateProvCode()
    {
        return $this->StateProvCode;
    }
    /**
     * Set StateProvCode value
     * @param string $stateProvCode
     * @return \StructType\Area
     */
    public function setStateProvCode($stateProvCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateProvCode) && !is_string($stateProvCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateProvCode, true), gettype($stateProvCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($stateProvCode) && mb_strlen($stateProvCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($stateProvCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($stateProvCode) && mb_strlen($stateProvCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($stateProvCode)), __LINE__);
        }
        $this->StateProvCode = $stateProvCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\Area
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{2})
        if (!is_null($countryCode) && !preg_match('/[a-zA-Z]{2}/', $countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{2}', var_export($countryCode, true)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get AreaID value
     * @return string|null
     */
    public function getAreaID()
    {
        return $this->AreaID;
    }
    /**
     * Set AreaID value
     * @param string $areaID
     * @return \StructType\Area
     */
    public function setAreaID($areaID = null)
    {
        // validation for constraint: string
        if (!is_null($areaID) && !is_string($areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaID, true), gettype($areaID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($areaID) && !preg_match('/[0-9]{1,8}/', $areaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($areaID, true)), __LINE__);
        }
        $this->AreaID = $areaID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Area
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
