<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmountPercentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides a monetary amount and the currency code to reflect the currency in which this amount is expressed. | Defines the percentage basis for calculating the fee amount or the amount.
 * @subpackage Structs
 */
class AmountPercentType extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - documentation: A collection of taxes.
     * - minOccurs: 0
     * @var \StructType\TaxesType
     */
    public $Taxes;
    /**
     * The TaxInclusive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether taxes are included when figuring the base amount.
     * - use: optional
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The FeesInclusive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether fees, such as those imposed by a travel agency or other booking agent, are included when figuring cancel penalties.
     * - use: optional
     * @var bool
     */
    public $FeesInclusive;
    /**
     * The NmbrOfNights
     * Meta information extracted from the WSDL
     * - documentation: The number of nights of the hotel stay that are used to calculate the fee amount.
     * - use: optional
     * @var int
     */
    public $NmbrOfNights;
    /**
     * The BasisType
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $BasisType;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: The percentage used to calculate the amount. | Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The ApplyAs
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ApplyAs;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for AmountPercentType
     * @uses AmountPercentType::setTaxes()
     * @uses AmountPercentType::setTaxInclusive()
     * @uses AmountPercentType::setFeesInclusive()
     * @uses AmountPercentType::setNmbrOfNights()
     * @uses AmountPercentType::setBasisType()
     * @uses AmountPercentType::setPercent()
     * @uses AmountPercentType::setApplyAs()
     * @uses AmountPercentType::setAmount()
     * @uses AmountPercentType::setCurrencyCode()
     * @uses AmountPercentType::setDecimalPlaces()
     * @param \StructType\TaxesType $taxes
     * @param bool $taxInclusive
     * @param bool $feesInclusive
     * @param int $nmbrOfNights
     * @param string $basisType
     * @param float $percent
     * @param string $applyAs
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(\StructType\TaxesType $taxes = null, $taxInclusive = null, $feesInclusive = null, $nmbrOfNights = null, $basisType = null, $percent = null, $applyAs = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setTaxes($taxes)
            ->setTaxInclusive($taxInclusive)
            ->setFeesInclusive($feesInclusive)
            ->setNmbrOfNights($nmbrOfNights)
            ->setBasisType($basisType)
            ->setPercent($percent)
            ->setApplyAs($applyAs)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get Taxes value
     * @return \StructType\TaxesType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\TaxesType $taxes
     * @return \StructType\AmountPercentType
     */
    public function setTaxes(\StructType\TaxesType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \StructType\AmountPercentType
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusive, true), gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get FeesInclusive value
     * @return bool|null
     */
    public function getFeesInclusive()
    {
        return $this->FeesInclusive;
    }
    /**
     * Set FeesInclusive value
     * @param bool $feesInclusive
     * @return \StructType\AmountPercentType
     */
    public function setFeesInclusive($feesInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($feesInclusive) && !is_bool($feesInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($feesInclusive, true), gettype($feesInclusive)), __LINE__);
        }
        $this->FeesInclusive = $feesInclusive;
        return $this;
    }
    /**
     * Get NmbrOfNights value
     * @return int|null
     */
    public function getNmbrOfNights()
    {
        return $this->NmbrOfNights;
    }
    /**
     * Set NmbrOfNights value
     * @param int $nmbrOfNights
     * @return \StructType\AmountPercentType
     */
    public function setNmbrOfNights($nmbrOfNights = null)
    {
        // validation for constraint: int
        if (!is_null($nmbrOfNights) && !(is_int($nmbrOfNights) || ctype_digit($nmbrOfNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nmbrOfNights, true), gettype($nmbrOfNights)), __LINE__);
        }
        $this->NmbrOfNights = $nmbrOfNights;
        return $this;
    }
    /**
     * Get BasisType value
     * @return string|null
     */
    public function getBasisType()
    {
        return $this->BasisType;
    }
    /**
     * Set BasisType value
     * @param string $basisType
     * @return \StructType\AmountPercentType
     */
    public function setBasisType($basisType = null)
    {
        // validation for constraint: string
        if (!is_null($basisType) && !is_string($basisType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basisType, true), gettype($basisType)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($basisType) && mb_strlen($basisType) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($basisType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($basisType) && mb_strlen($basisType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($basisType)), __LINE__);
        }
        $this->BasisType = $basisType;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\AmountPercentType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($percent) && $percent > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($percent, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($percent) && $percent < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($percent, true)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get ApplyAs value
     * @return string|null
     */
    public function getApplyAs()
    {
        return $this->ApplyAs;
    }
    /**
     * Set ApplyAs value
     * @param string $applyAs
     * @return \StructType\AmountPercentType
     */
    public function setApplyAs($applyAs = null)
    {
        // validation for constraint: string
        if (!is_null($applyAs) && !is_string($applyAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applyAs, true), gettype($applyAs)), __LINE__);
        }
        $this->ApplyAs = $applyAs;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AmountPercentType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AmountPercentType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\AmountPercentType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AmountPercentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
