<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTraveler StructType
 * Meta information extracted from the WSDL
 * - documentation: Information about the person traveling.
 * @subpackage Structs
 */
class AirTraveler extends AirTravelerType
{
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Comment[]
     */
    public $Comment;
    /**
     * Constructor method for AirTraveler
     * @uses AirTraveler::setComment()
     * @param \StructType\Comment[] $comment
     */
    public function __construct(array $comment = array())
    {
        $this
            ->setComment($comment);
    }
    /**
     * Get Comment value
     * @return \StructType\Comment[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * This method is responsible for validating the values passed to the setComment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommentForArrayConstraintsFromSetComment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airTravelerCommentItem) {
            // validation for constraint: itemType
            if (!$airTravelerCommentItem instanceof \StructType\Comment) {
                $invalidValues[] = is_object($airTravelerCommentItem) ? get_class($airTravelerCommentItem) : sprintf('%s(%s)', gettype($airTravelerCommentItem), var_export($airTravelerCommentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Comment property can only contain items of type \StructType\Comment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\Comment[] $comment
     * @return \StructType\AirTraveler
     */
    public function setComment(array $comment = array())
    {
        // validation for constraint: array
        if ('' !== ($commentArrayErrorMessage = self::validateCommentForArrayConstraintsFromSetComment($comment))) {
            throw new \InvalidArgumentException($commentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($comment) && count($comment) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param \StructType\Comment $item
     * @return \StructType\AirTraveler
     */
    public function addToComment(\StructType\Comment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Comment) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of type \StructType\Comment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Comment) && count($this->Comment) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Comment)), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirTraveler
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
