<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirSearchPrefsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify the earliest and latest departure times for which flights are requested. | Request smoking flights in response. Defaults to false - no desire for smoking flights. | Defines user preferences to be used in conducting a
 * search.
 * @subpackage Structs
 */
class AirSearchPrefsType extends AbstractStructBase
{
    /**
     * The VendorPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\VendorPref[]
     */
    public $VendorPref;
    /**
     * The FlightTypePref
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\FlightTypePref[]
     */
    public $FlightTypePref;
    /**
     * The FareRestrictPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \StructType\FareRestrictPref[]
     */
    public $FareRestrictPref;
    /**
     * The EquipPref
     * Meta information extracted from the WSDL
     * - documentation: Defines preferred equipment profile(s) to be used in a search.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\EquipmentTypePref[]
     */
    public $EquipPref;
    /**
     * The CabinPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\CabinPref[]
     */
    public $CabinPref;
    /**
     * The TicketDistribPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\TicketDistribPref[]
     */
    public $TicketDistribPref;
    /**
     * The BookingSeatPref
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BookingSeatPref
     */
    public $BookingSeatPref;
    /**
     * The OnTimeRate
     * Meta information extracted from the WSDL
     * - documentation: Request for flights in response that meet the given Department of Transport on-time rate. This is a number between 0 and 100. | Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $OnTimeRate;
    /**
     * The ETicketDesired
     * Meta information extracted from the WSDL
     * - documentation: false | Request flights that are e-ticketable in the response.
     * - use: optional
     * @var bool
     */
    public $ETicketDesired;
    /**
     * The MaxStopsQuantity
     * Meta information extracted from the WSDL
     * - documentation: Request flights that have no more than the requested number of stops. | Used for Numeric values, from 0 to 4 inclusive.
     * - base: xs:integer
     * - maxInclusive: 4
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $MaxStopsQuantity;
    /**
     * The SmokingAllowed
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * Constructor method for AirSearchPrefsType
     * @uses AirSearchPrefsType::setVendorPref()
     * @uses AirSearchPrefsType::setFlightTypePref()
     * @uses AirSearchPrefsType::setFareRestrictPref()
     * @uses AirSearchPrefsType::setEquipPref()
     * @uses AirSearchPrefsType::setCabinPref()
     * @uses AirSearchPrefsType::setTicketDistribPref()
     * @uses AirSearchPrefsType::setBookingSeatPref()
     * @uses AirSearchPrefsType::setOnTimeRate()
     * @uses AirSearchPrefsType::setETicketDesired()
     * @uses AirSearchPrefsType::setMaxStopsQuantity()
     * @uses AirSearchPrefsType::setSmokingAllowed()
     * @uses AirSearchPrefsType::setStart()
     * @uses AirSearchPrefsType::setDuration()
     * @uses AirSearchPrefsType::setEnd()
     * @param \StructType\VendorPref[] $vendorPref
     * @param \StructType\FlightTypePref[] $flightTypePref
     * @param \StructType\FareRestrictPref[] $fareRestrictPref
     * @param \StructType\EquipmentTypePref[] $equipPref
     * @param \StructType\CabinPref[] $cabinPref
     * @param \StructType\TicketDistribPref[] $ticketDistribPref
     * @param \StructType\BookingSeatPref $bookingSeatPref
     * @param float $onTimeRate
     * @param bool $eTicketDesired
     * @param int $maxStopsQuantity
     * @param bool $smokingAllowed
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(array $vendorPref = array(), array $flightTypePref = array(), array $fareRestrictPref = array(), array $equipPref = array(), array $cabinPref = array(), array $ticketDistribPref = array(), \StructType\BookingSeatPref $bookingSeatPref = null, $onTimeRate = null, $eTicketDesired = null, $maxStopsQuantity = null, $smokingAllowed = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setVendorPref($vendorPref)
            ->setFlightTypePref($flightTypePref)
            ->setFareRestrictPref($fareRestrictPref)
            ->setEquipPref($equipPref)
            ->setCabinPref($cabinPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setBookingSeatPref($bookingSeatPref)
            ->setOnTimeRate($onTimeRate)
            ->setETicketDesired($eTicketDesired)
            ->setMaxStopsQuantity($maxStopsQuantity)
            ->setSmokingAllowed($smokingAllowed)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get VendorPref value
     * @return \StructType\VendorPref[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorPrefForArrayConstraintsFromSetVendorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airSearchPrefsTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeVendorPrefItem instanceof \StructType\VendorPref) {
                $invalidValues[] = is_object($airSearchPrefsTypeVendorPrefItem) ? get_class($airSearchPrefsTypeVendorPrefItem) : sprintf('%s(%s)', gettype($airSearchPrefsTypeVendorPrefItem), var_export($airSearchPrefsTypeVendorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorPref property can only contain items of type \StructType\VendorPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorPref[] $vendorPref
     * @return \StructType\AirSearchPrefsType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorPrefArrayErrorMessage = self::validateVendorPrefForArrayConstraintsFromSetVendorPref($vendorPref))) {
            throw new \InvalidArgumentException($vendorPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($vendorPref) && count($vendorPref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($vendorPref)), __LINE__);
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorPref $item
     * @return \StructType\AirSearchPrefsType
     */
    public function addToVendorPref(\StructType\VendorPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorPref) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of type \StructType\VendorPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->VendorPref) && count($this->VendorPref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->VendorPref)), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \StructType\FlightTypePref[]|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightTypePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightTypePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightTypePrefForArrayConstraintsFromSetFlightTypePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airSearchPrefsTypeFlightTypePrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeFlightTypePrefItem instanceof \StructType\FlightTypePref) {
                $invalidValues[] = is_object($airSearchPrefsTypeFlightTypePrefItem) ? get_class($airSearchPrefsTypeFlightTypePrefItem) : sprintf('%s(%s)', gettype($airSearchPrefsTypeFlightTypePrefItem), var_export($airSearchPrefsTypeFlightTypePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightTypePref property can only contain items of type \StructType\FlightTypePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightTypePref[] $flightTypePref
     * @return \StructType\AirSearchPrefsType
     */
    public function setFlightTypePref(array $flightTypePref = array())
    {
        // validation for constraint: array
        if ('' !== ($flightTypePrefArrayErrorMessage = self::validateFlightTypePrefForArrayConstraintsFromSetFlightTypePref($flightTypePref))) {
            throw new \InvalidArgumentException($flightTypePrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($flightTypePref) && count($flightTypePref) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($flightTypePref)), __LINE__);
        }
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Add item to FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightTypePref $item
     * @return \StructType\AirSearchPrefsType
     */
    public function addToFlightTypePref(\StructType\FlightTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightTypePref) {
            throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of type \StructType\FlightTypePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->FlightTypePref) && count($this->FlightTypePref) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->FlightTypePref)), __LINE__);
        }
        $this->FlightTypePref[] = $item;
        return $this;
    }
    /**
     * Get FareRestrictPref value
     * @return \StructType\FareRestrictPref[]|null
     */
    public function getFareRestrictPref()
    {
        return $this->FareRestrictPref;
    }
    /**
     * This method is responsible for validating the values passed to the setFareRestrictPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareRestrictPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareRestrictPrefForArrayConstraintsFromSetFareRestrictPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airSearchPrefsTypeFareRestrictPrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeFareRestrictPrefItem instanceof \StructType\FareRestrictPref) {
                $invalidValues[] = is_object($airSearchPrefsTypeFareRestrictPrefItem) ? get_class($airSearchPrefsTypeFareRestrictPrefItem) : sprintf('%s(%s)', gettype($airSearchPrefsTypeFareRestrictPrefItem), var_export($airSearchPrefsTypeFareRestrictPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareRestrictPref property can only contain items of type \StructType\FareRestrictPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRestrictPref[] $fareRestrictPref
     * @return \StructType\AirSearchPrefsType
     */
    public function setFareRestrictPref(array $fareRestrictPref = array())
    {
        // validation for constraint: array
        if ('' !== ($fareRestrictPrefArrayErrorMessage = self::validateFareRestrictPrefForArrayConstraintsFromSetFareRestrictPref($fareRestrictPref))) {
            throw new \InvalidArgumentException($fareRestrictPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($fareRestrictPref) && count($fareRestrictPref) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($fareRestrictPref)), __LINE__);
        }
        $this->FareRestrictPref = $fareRestrictPref;
        return $this;
    }
    /**
     * Add item to FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRestrictPref $item
     * @return \StructType\AirSearchPrefsType
     */
    public function addToFareRestrictPref(\StructType\FareRestrictPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareRestrictPref) {
            throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of type \StructType\FareRestrictPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->FareRestrictPref) && count($this->FareRestrictPref) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->FareRestrictPref)), __LINE__);
        }
        $this->FareRestrictPref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return \StructType\EquipmentTypePref[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * This method is responsible for validating the values passed to the setEquipPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquipPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquipPrefForArrayConstraintsFromSetEquipPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airSearchPrefsTypeEquipPrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeEquipPrefItem instanceof \StructType\EquipmentTypePref) {
                $invalidValues[] = is_object($airSearchPrefsTypeEquipPrefItem) ? get_class($airSearchPrefsTypeEquipPrefItem) : sprintf('%s(%s)', gettype($airSearchPrefsTypeEquipPrefItem), var_export($airSearchPrefsTypeEquipPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EquipPref property can only contain items of type \StructType\EquipmentTypePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EquipPref value
     * @throws \InvalidArgumentException
     * @param \StructType\EquipmentTypePref[] $equipPref
     * @return \StructType\AirSearchPrefsType
     */
    public function setEquipPref(array $equipPref = array())
    {
        // validation for constraint: array
        if ('' !== ($equipPrefArrayErrorMessage = self::validateEquipPrefForArrayConstraintsFromSetEquipPref($equipPref))) {
            throw new \InvalidArgumentException($equipPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($equipPref) && count($equipPref) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($equipPref)), __LINE__);
        }
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param \StructType\EquipmentTypePref $item
     * @return \StructType\AirSearchPrefsType
     */
    public function addToEquipPref(\StructType\EquipmentTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EquipmentTypePref) {
            throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of type \StructType\EquipmentTypePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->EquipPref) && count($this->EquipPref) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->EquipPref)), __LINE__);
        }
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \StructType\CabinPref[]|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinPrefForArrayConstraintsFromSetCabinPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airSearchPrefsTypeCabinPrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeCabinPrefItem instanceof \StructType\CabinPref) {
                $invalidValues[] = is_object($airSearchPrefsTypeCabinPrefItem) ? get_class($airSearchPrefsTypeCabinPrefItem) : sprintf('%s(%s)', gettype($airSearchPrefsTypeCabinPrefItem), var_export($airSearchPrefsTypeCabinPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinPref property can only contain items of type \StructType\CabinPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinPref[] $cabinPref
     * @return \StructType\AirSearchPrefsType
     */
    public function setCabinPref(array $cabinPref = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinPrefArrayErrorMessage = self::validateCabinPrefForArrayConstraintsFromSetCabinPref($cabinPref))) {
            throw new \InvalidArgumentException($cabinPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($cabinPref) && count($cabinPref) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($cabinPref)), __LINE__);
        }
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Add item to CabinPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinPref $item
     * @return \StructType\AirSearchPrefsType
     */
    public function addToCabinPref(\StructType\CabinPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinPref) {
            throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of type \StructType\CabinPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->CabinPref) && count($this->CabinPref) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->CabinPref)), __LINE__);
        }
        $this->CabinPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \StructType\TicketDistribPref[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDistribPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDistribPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airSearchPrefsTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (!$airSearchPrefsTypeTicketDistribPrefItem instanceof \StructType\TicketDistribPref) {
                $invalidValues[] = is_object($airSearchPrefsTypeTicketDistribPrefItem) ? get_class($airSearchPrefsTypeTicketDistribPrefItem) : sprintf('%s(%s)', gettype($airSearchPrefsTypeTicketDistribPrefItem), var_export($airSearchPrefsTypeTicketDistribPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDistribPref property can only contain items of type \StructType\TicketDistribPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDistribPref[] $ticketDistribPref
     * @return \StructType\AirSearchPrefsType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDistribPrefArrayErrorMessage = self::validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref($ticketDistribPref))) {
            throw new \InvalidArgumentException($ticketDistribPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($ticketDistribPref) && count($ticketDistribPref) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($ticketDistribPref)), __LINE__);
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \StructType\TicketDistribPref $item
     * @return \StructType\AirSearchPrefsType
     */
    public function addToTicketDistribPref(\StructType\TicketDistribPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TicketDistribPref) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of type \StructType\TicketDistribPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->TicketDistribPref) && count($this->TicketDistribPref) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->TicketDistribPref)), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get BookingSeatPref value
     * @return \StructType\BookingSeatPref|null
     */
    public function getBookingSeatPref()
    {
        return $this->BookingSeatPref;
    }
    /**
     * Set BookingSeatPref value
     * @param \StructType\BookingSeatPref $bookingSeatPref
     * @return \StructType\AirSearchPrefsType
     */
    public function setBookingSeatPref(\StructType\BookingSeatPref $bookingSeatPref = null)
    {
        $this->BookingSeatPref = $bookingSeatPref;
        return $this;
    }
    /**
     * Get OnTimeRate value
     * @return float|null
     */
    public function getOnTimeRate()
    {
        return $this->OnTimeRate;
    }
    /**
     * Set OnTimeRate value
     * @param float $onTimeRate
     * @return \StructType\AirSearchPrefsType
     */
    public function setOnTimeRate($onTimeRate = null)
    {
        // validation for constraint: float
        if (!is_null($onTimeRate) && !(is_float($onTimeRate) || is_numeric($onTimeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($onTimeRate, true), gettype($onTimeRate)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($onTimeRate) && $onTimeRate > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($onTimeRate, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($onTimeRate) && $onTimeRate < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($onTimeRate, true)), __LINE__);
        }
        $this->OnTimeRate = $onTimeRate;
        return $this;
    }
    /**
     * Get ETicketDesired value
     * @return bool|null
     */
    public function getETicketDesired()
    {
        return $this->ETicketDesired;
    }
    /**
     * Set ETicketDesired value
     * @param bool $eTicketDesired
     * @return \StructType\AirSearchPrefsType
     */
    public function setETicketDesired($eTicketDesired = null)
    {
        // validation for constraint: boolean
        if (!is_null($eTicketDesired) && !is_bool($eTicketDesired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eTicketDesired, true), gettype($eTicketDesired)), __LINE__);
        }
        $this->ETicketDesired = $eTicketDesired;
        return $this;
    }
    /**
     * Get MaxStopsQuantity value
     * @return int|null
     */
    public function getMaxStopsQuantity()
    {
        return $this->MaxStopsQuantity;
    }
    /**
     * Set MaxStopsQuantity value
     * @param int $maxStopsQuantity
     * @return \StructType\AirSearchPrefsType
     */
    public function setMaxStopsQuantity($maxStopsQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maxStopsQuantity) && !(is_int($maxStopsQuantity) || ctype_digit($maxStopsQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxStopsQuantity, true), gettype($maxStopsQuantity)), __LINE__);
        }
        // validation for constraint: maxInclusive(4)
        if (!is_null($maxStopsQuantity) && $maxStopsQuantity > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 4', var_export($maxStopsQuantity, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($maxStopsQuantity) && $maxStopsQuantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($maxStopsQuantity, true)), __LINE__);
        }
        $this->MaxStopsQuantity = $maxStopsQuantity;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\AirSearchPrefsType
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\AirSearchPrefsType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\AirSearchPrefsType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\AirSearchPrefsType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirSearchPrefsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
