<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirRowCharacteristics StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains a list of characteristics of an air row.
 * @subpackage Structs
 */
class AirRowCharacteristics extends AbstractStructBase
{
    /**
     * The CharacteristicList
     * Meta information extracted from the WSDL
     * - documentation: Describes the characteristics of a specific seat row. Refer to OpenTravel Code List Air Row Type (ROW). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X. | List of
     * OpenTravel Codes.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: required
     * @var string[]
     */
    public $CharacteristicList;
    /**
     * Constructor method for AirRowCharacteristics
     * @uses AirRowCharacteristics::setCharacteristicList()
     * @param string[] $characteristicList
     */
    public function __construct(array $characteristicList = array())
    {
        $this
            ->setCharacteristicList($characteristicList);
    }
    /**
     * Get CharacteristicList value
     * @return string[]
     */
    public function getCharacteristicList()
    {
        return $this->CharacteristicList;
    }
    /**
     * This method is responsible for validating the values passed to the setCharacteristicList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharacteristicList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCharacteristicListForArrayConstraintsFromSetCharacteristicList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airRowCharacteristicsCharacteristicListItem) {
            // validation for constraint: itemType
            if (!is_string($airRowCharacteristicsCharacteristicListItem)) {
                $invalidValues[] = is_object($airRowCharacteristicsCharacteristicListItem) ? get_class($airRowCharacteristicsCharacteristicListItem) : sprintf('%s(%s)', gettype($airRowCharacteristicsCharacteristicListItem), var_export($airRowCharacteristicsCharacteristicListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CharacteristicList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CharacteristicList value
     * @param string[] $characteristicList
     * @return \StructType\AirRowCharacteristics
     */
    public function setCharacteristicList(array $characteristicList = array())
    {
        // validation for constraint: list
        if ('' !== ($characteristicListArrayErrorMessage = self::validateCharacteristicListForArrayConstraintsFromSetCharacteristicList($characteristicList))) {
            throw new \InvalidArgumentException($characteristicListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($characteristicList) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $characteristicList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($characteristicList, true)), __LINE__);
        }
        $this->CharacteristicList = is_array($characteristicList) ? implode(' ', $characteristicList) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirRowCharacteristics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
