<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgeInfos StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of descriptions about the different requirements related to age of driver
 * @subpackage Structs
 */
class AgeInfos extends AbstractStructBase
{
    /**
     * The AgeInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\AgeInfo[]
     */
    public $AgeInfo;
    /**
     * Constructor method for AgeInfos
     * @uses AgeInfos::setAgeInfo()
     * @param \StructType\AgeInfo[] $ageInfo
     */
    public function __construct(array $ageInfo = array())
    {
        $this
            ->setAgeInfo($ageInfo);
    }
    /**
     * Get AgeInfo value
     * @return \StructType\AgeInfo[]|null
     */
    public function getAgeInfo()
    {
        return $this->AgeInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setAgeInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAgeInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAgeInfoForArrayConstraintsFromSetAgeInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ageInfosAgeInfoItem) {
            // validation for constraint: itemType
            if (!$ageInfosAgeInfoItem instanceof \StructType\AgeInfo) {
                $invalidValues[] = is_object($ageInfosAgeInfoItem) ? get_class($ageInfosAgeInfoItem) : sprintf('%s(%s)', gettype($ageInfosAgeInfoItem), var_export($ageInfosAgeInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AgeInfo property can only contain items of type \StructType\AgeInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AgeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AgeInfo[] $ageInfo
     * @return \StructType\AgeInfos
     */
    public function setAgeInfo(array $ageInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($ageInfoArrayErrorMessage = self::validateAgeInfoForArrayConstraintsFromSetAgeInfo($ageInfo))) {
            throw new \InvalidArgumentException($ageInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($ageInfo) && count($ageInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($ageInfo)), __LINE__);
        }
        $this->AgeInfo = $ageInfo;
        return $this;
    }
    /**
     * Add item to AgeInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AgeInfo $item
     * @return \StructType\AgeInfos
     */
    public function addToAgeInfo(\StructType\AgeInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AgeInfo) {
            throw new \InvalidArgumentException(sprintf('The AgeInfo property can only contain items of type \StructType\AgeInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AgeInfo) && count($this->AgeInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AgeInfo)), __LINE__);
        }
        $this->AgeInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AgeInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
