<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvanceBookingRestriction StructType
 * Meta information extracted from the WSDL
 * - documentation: The day(s) of the week either on which the booking may be made or the day(s) of arrival for the booking. | The period of time during which the booking must be made. | The period during which the booking must be made.
 * @subpackage Structs
 */
class AdvanceBookingRestriction extends AbstractStructBase
{
    /**
     * The MinAdvanceBookingOffset
     * Meta information extracted from the WSDL
     * - documentation: The minimum lead time required for the booking.
     * - use: optional
     * @var string
     */
    public $MinAdvanceBookingOffset;
    /**
     * The MaxAdvanceBookingOffset
     * Meta information extracted from the WSDL
     * - documentation: The maximum lead time required for the booking.
     * - use: optional
     * @var string
     */
    public $MaxAdvanceBookingOffset;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * The Mon
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * @var bool
     */
    public $Tue;
    /**
     * The Weds
     * @var bool
     */
    public $Weds;
    /**
     * The Thur
     * @var bool
     */
    public $Thur;
    /**
     * The Fri
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * @var bool
     */
    public $Sat;
    /**
     * The Sun
     * @var bool
     */
    public $Sun;
    /**
     * Constructor method for AdvanceBookingRestriction
     * @uses AdvanceBookingRestriction::setMinAdvanceBookingOffset()
     * @uses AdvanceBookingRestriction::setMaxAdvanceBookingOffset()
     * @uses AdvanceBookingRestriction::setStart()
     * @uses AdvanceBookingRestriction::setDuration()
     * @uses AdvanceBookingRestriction::setEnd()
     * @uses AdvanceBookingRestriction::setMon()
     * @uses AdvanceBookingRestriction::setTue()
     * @uses AdvanceBookingRestriction::setWeds()
     * @uses AdvanceBookingRestriction::setThur()
     * @uses AdvanceBookingRestriction::setFri()
     * @uses AdvanceBookingRestriction::setSat()
     * @uses AdvanceBookingRestriction::setSun()
     * @param string $minAdvanceBookingOffset
     * @param string $maxAdvanceBookingOffset
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param bool $mon
     * @param bool $tue
     * @param bool $weds
     * @param bool $thur
     * @param bool $fri
     * @param bool $sat
     * @param bool $sun
     */
    public function __construct($minAdvanceBookingOffset = null, $maxAdvanceBookingOffset = null, $start = null, $duration = null, $end = null, $mon = null, $tue = null, $weds = null, $thur = null, $fri = null, $sat = null, $sun = null)
    {
        $this
            ->setMinAdvanceBookingOffset($minAdvanceBookingOffset)
            ->setMaxAdvanceBookingOffset($maxAdvanceBookingOffset)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setMon($mon)
            ->setTue($tue)
            ->setWeds($weds)
            ->setThur($thur)
            ->setFri($fri)
            ->setSat($sat)
            ->setSun($sun);
    }
    /**
     * Get MinAdvanceBookingOffset value
     * @return string|null
     */
    public function getMinAdvanceBookingOffset()
    {
        return $this->MinAdvanceBookingOffset;
    }
    /**
     * Set MinAdvanceBookingOffset value
     * @param string $minAdvanceBookingOffset
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setMinAdvanceBookingOffset($minAdvanceBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($minAdvanceBookingOffset) && !is_string($minAdvanceBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minAdvanceBookingOffset, true), gettype($minAdvanceBookingOffset)), __LINE__);
        }
        $this->MinAdvanceBookingOffset = $minAdvanceBookingOffset;
        return $this;
    }
    /**
     * Get MaxAdvanceBookingOffset value
     * @return string|null
     */
    public function getMaxAdvanceBookingOffset()
    {
        return $this->MaxAdvanceBookingOffset;
    }
    /**
     * Set MaxAdvanceBookingOffset value
     * @param string $maxAdvanceBookingOffset
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setMaxAdvanceBookingOffset($maxAdvanceBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($maxAdvanceBookingOffset) && !is_string($maxAdvanceBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxAdvanceBookingOffset, true), gettype($maxAdvanceBookingOffset)), __LINE__);
        }
        $this->MaxAdvanceBookingOffset = $maxAdvanceBookingOffset;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool|null
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mon, true), gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool|null
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tue, true), gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Weds value
     * @return bool|null
     */
    public function getWeds()
    {
        return $this->Weds;
    }
    /**
     * Set Weds value
     * @param bool $weds
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setWeds($weds = null)
    {
        // validation for constraint: boolean
        if (!is_null($weds) && !is_bool($weds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($weds, true), gettype($weds)), __LINE__);
        }
        $this->Weds = $weds;
        return $this;
    }
    /**
     * Get Thur value
     * @return bool|null
     */
    public function getThur()
    {
        return $this->Thur;
    }
    /**
     * Set Thur value
     * @param bool $thur
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setThur($thur = null)
    {
        // validation for constraint: boolean
        if (!is_null($thur) && !is_bool($thur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($thur, true), gettype($thur)), __LINE__);
        }
        $this->Thur = $thur;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool|null
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fri, true), gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool|null
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sat, true), gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool|null
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \StructType\AdvanceBookingRestriction
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sun, true), gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdvanceBookingRestriction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
