<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvTicketing StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies advance ticketing restrictions.
 * @subpackage Structs
 */
class AdvTicketing extends AbstractStructBase
{
    /**
     * The FromResTimeOfDay
     * Meta information extracted from the WSDL
     * - documentation: The time of day after reservations are made by which a ticket must be purchased. | Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * - use: optional
     * @var string
     */
    public $FromResTimeOfDay;
    /**
     * The FromResPeriod
     * Meta information extracted from the WSDL
     * - documentation: A length of time expressed as either an amount of time or the number of occurrences of a day of the week after reservations are made that a ticket must be purchased. | Used for Numeric Strings length 1 to 3.
     * - base: xs:string
     * - pattern: [0-9]{1,3}
     * - use: optional
     * @var string
     */
    public $FromResPeriod;
    /**
     * The FromResUnit
     * Meta information extracted from the WSDL
     * - documentation: The unit of elapsed time or the day of the week to be applied to the period after reservation are made that a ticket must be purchased.
     * - use: optional
     * @var string
     */
    public $FromResUnit;
    /**
     * The FromDepartTimeOfDay
     * Meta information extracted from the WSDL
     * - documentation: The time of day prior to departure when that a ticket must be purchased. | Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * - use: optional
     * @var string
     */
    public $FromDepartTimeOfDay;
    /**
     * The FromDepartPeriod
     * Meta information extracted from the WSDL
     * - documentation: A length of time expressed as either an amount of time or the number of occurrences of a day of the week before departure that a ticket must be purchased. | Used for Numeric Strings length 1 to 3.
     * - base: xs:string
     * - pattern: [0-9]{1,3}
     * - use: optional
     * @var string
     */
    public $FromDepartPeriod;
    /**
     * The FromDepartUnit
     * Meta information extracted from the WSDL
     * - documentation: The unit of elapsed time or the day of the week to be applied to the the period before departure that a ticket must be purchased.
     * - use: optional
     * @var string
     */
    public $FromDepartUnit;
    /**
     * Constructor method for AdvTicketing
     * @uses AdvTicketing::setFromResTimeOfDay()
     * @uses AdvTicketing::setFromResPeriod()
     * @uses AdvTicketing::setFromResUnit()
     * @uses AdvTicketing::setFromDepartTimeOfDay()
     * @uses AdvTicketing::setFromDepartPeriod()
     * @uses AdvTicketing::setFromDepartUnit()
     * @param string $fromResTimeOfDay
     * @param string $fromResPeriod
     * @param string $fromResUnit
     * @param string $fromDepartTimeOfDay
     * @param string $fromDepartPeriod
     * @param string $fromDepartUnit
     */
    public function __construct($fromResTimeOfDay = null, $fromResPeriod = null, $fromResUnit = null, $fromDepartTimeOfDay = null, $fromDepartPeriod = null, $fromDepartUnit = null)
    {
        $this
            ->setFromResTimeOfDay($fromResTimeOfDay)
            ->setFromResPeriod($fromResPeriod)
            ->setFromResUnit($fromResUnit)
            ->setFromDepartTimeOfDay($fromDepartTimeOfDay)
            ->setFromDepartPeriod($fromDepartPeriod)
            ->setFromDepartUnit($fromDepartUnit);
    }
    /**
     * Get FromResTimeOfDay value
     * @return string|null
     */
    public function getFromResTimeOfDay()
    {
        return $this->FromResTimeOfDay;
    }
    /**
     * This method is responsible for validating the value passed to the setFromResTimeOfDay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFromResTimeOfDay method
     * This is a set of validation rules based on the union types associated to the property being set by the setFromResTimeOfDay method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFromResTimeOfDayForUnionConstraintsFromSetFromResTimeOfDay($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set FromResTimeOfDay value
     * @param string $fromResTimeOfDay
     * @return \StructType\AdvTicketing
     */
    public function setFromResTimeOfDay($fromResTimeOfDay = null)
    {
        // validation for constraint: string
        if (!is_null($fromResTimeOfDay) && !is_string($fromResTimeOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromResTimeOfDay, true), gettype($fromResTimeOfDay)), __LINE__);
        }
        // validation for constraint: union(dateTime, time)
        if ('' !== ($fromResTimeOfDayUnionErrorMessage = self::validateFromResTimeOfDayForUnionConstraintsFromSetFromResTimeOfDay($fromResTimeOfDay))) {
            throw new \InvalidArgumentException($fromResTimeOfDayUnionErrorMessage, __LINE__);
        }
        $this->FromResTimeOfDay = $fromResTimeOfDay;
        return $this;
    }
    /**
     * Get FromResPeriod value
     * @return string|null
     */
    public function getFromResPeriod()
    {
        return $this->FromResPeriod;
    }
    /**
     * Set FromResPeriod value
     * @param string $fromResPeriod
     * @return \StructType\AdvTicketing
     */
    public function setFromResPeriod($fromResPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($fromResPeriod) && !is_string($fromResPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromResPeriod, true), gettype($fromResPeriod)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,3})
        if (!is_null($fromResPeriod) && !preg_match('/[0-9]{1,3}/', $fromResPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,3}', var_export($fromResPeriod, true)), __LINE__);
        }
        $this->FromResPeriod = $fromResPeriod;
        return $this;
    }
    /**
     * Get FromResUnit value
     * @return string|null
     */
    public function getFromResUnit()
    {
        return $this->FromResUnit;
    }
    /**
     * Set FromResUnit value
     * @uses \EnumType\StayUnitType::valueIsValid()
     * @uses \EnumType\StayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fromResUnit
     * @return \StructType\AdvTicketing
     */
    public function setFromResUnit($fromResUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StayUnitType::valueIsValid($fromResUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StayUnitType', is_array($fromResUnit) ? implode(', ', $fromResUnit) : var_export($fromResUnit, true), implode(', ', \EnumType\StayUnitType::getValidValues())), __LINE__);
        }
        $this->FromResUnit = $fromResUnit;
        return $this;
    }
    /**
     * Get FromDepartTimeOfDay value
     * @return string|null
     */
    public function getFromDepartTimeOfDay()
    {
        return $this->FromDepartTimeOfDay;
    }
    /**
     * This method is responsible for validating the value passed to the setFromDepartTimeOfDay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFromDepartTimeOfDay method
     * This is a set of validation rules based on the union types associated to the property being set by the setFromDepartTimeOfDay method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFromDepartTimeOfDayForUnionConstraintsFromSetFromDepartTimeOfDay($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set FromDepartTimeOfDay value
     * @param string $fromDepartTimeOfDay
     * @return \StructType\AdvTicketing
     */
    public function setFromDepartTimeOfDay($fromDepartTimeOfDay = null)
    {
        // validation for constraint: string
        if (!is_null($fromDepartTimeOfDay) && !is_string($fromDepartTimeOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDepartTimeOfDay, true), gettype($fromDepartTimeOfDay)), __LINE__);
        }
        // validation for constraint: union(dateTime, time)
        if ('' !== ($fromDepartTimeOfDayUnionErrorMessage = self::validateFromDepartTimeOfDayForUnionConstraintsFromSetFromDepartTimeOfDay($fromDepartTimeOfDay))) {
            throw new \InvalidArgumentException($fromDepartTimeOfDayUnionErrorMessage, __LINE__);
        }
        $this->FromDepartTimeOfDay = $fromDepartTimeOfDay;
        return $this;
    }
    /**
     * Get FromDepartPeriod value
     * @return string|null
     */
    public function getFromDepartPeriod()
    {
        return $this->FromDepartPeriod;
    }
    /**
     * Set FromDepartPeriod value
     * @param string $fromDepartPeriod
     * @return \StructType\AdvTicketing
     */
    public function setFromDepartPeriod($fromDepartPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($fromDepartPeriod) && !is_string($fromDepartPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDepartPeriod, true), gettype($fromDepartPeriod)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,3})
        if (!is_null($fromDepartPeriod) && !preg_match('/[0-9]{1,3}/', $fromDepartPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,3}', var_export($fromDepartPeriod, true)), __LINE__);
        }
        $this->FromDepartPeriod = $fromDepartPeriod;
        return $this;
    }
    /**
     * Get FromDepartUnit value
     * @return string|null
     */
    public function getFromDepartUnit()
    {
        return $this->FromDepartUnit;
    }
    /**
     * Set FromDepartUnit value
     * @uses \EnumType\StayUnitType::valueIsValid()
     * @uses \EnumType\StayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fromDepartUnit
     * @return \StructType\AdvTicketing
     */
    public function setFromDepartUnit($fromDepartUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StayUnitType::valueIsValid($fromDepartUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StayUnitType', is_array($fromDepartUnit) ? implode(', ', $fromDepartUnit) : var_export($fromDepartUnit, true), implode(', ', \EnumType\StayUnitType::getValidValues())), __LINE__);
        }
        $this->FromDepartUnit = $fromDepartUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdvTicketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
