<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvReservation StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies constraints on when advance reservations can be made.
 * @subpackage Structs
 */
class AdvReservation extends AbstractStructBase
{
    /**
     * The LatestTimeOfDay
     * Meta information extracted from the WSDL
     * - documentation: The time of day by which reservations must be made on the last day that advance reservations can be made. | Allows for the specification of a date time or just time.
     * - union: dateTime | time
     * - use: optional
     * @var string
     */
    public $LatestTimeOfDay;
    /**
     * The LatestPeriod
     * Meta information extracted from the WSDL
     * - documentation: The amount of elapsed time or number of occurrences of a day of the week before departure needed to satisfy an advance reservation requirement. | Used for Numeric Strings length 1 to 3.
     * - base: xs:string
     * - pattern: [0-9]{1,3}
     * - use: optional
     * @var string
     */
    public $LatestPeriod;
    /**
     * The LatestUnit
     * Meta information extracted from the WSDL
     * - documentation: The unit of elapsed time or the day of the week to be applied to the LatestPeriod value.
     * - use: optional
     * @var string
     */
    public $LatestUnit;
    /**
     * Constructor method for AdvReservation
     * @uses AdvReservation::setLatestTimeOfDay()
     * @uses AdvReservation::setLatestPeriod()
     * @uses AdvReservation::setLatestUnit()
     * @param string $latestTimeOfDay
     * @param string $latestPeriod
     * @param string $latestUnit
     */
    public function __construct($latestTimeOfDay = null, $latestPeriod = null, $latestUnit = null)
    {
        $this
            ->setLatestTimeOfDay($latestTimeOfDay)
            ->setLatestPeriod($latestPeriod)
            ->setLatestUnit($latestUnit);
    }
    /**
     * Get LatestTimeOfDay value
     * @return string|null
     */
    public function getLatestTimeOfDay()
    {
        return $this->LatestTimeOfDay;
    }
    /**
     * This method is responsible for validating the value passed to the setLatestTimeOfDay method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLatestTimeOfDay method
     * This is a set of validation rules based on the union types associated to the property being set by the setLatestTimeOfDay method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLatestTimeOfDayForUnionConstraintsFromSetLatestTimeOfDay($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set LatestTimeOfDay value
     * @param string $latestTimeOfDay
     * @return \StructType\AdvReservation
     */
    public function setLatestTimeOfDay($latestTimeOfDay = null)
    {
        // validation for constraint: string
        if (!is_null($latestTimeOfDay) && !is_string($latestTimeOfDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestTimeOfDay, true), gettype($latestTimeOfDay)), __LINE__);
        }
        // validation for constraint: union(dateTime, time)
        if ('' !== ($latestTimeOfDayUnionErrorMessage = self::validateLatestTimeOfDayForUnionConstraintsFromSetLatestTimeOfDay($latestTimeOfDay))) {
            throw new \InvalidArgumentException($latestTimeOfDayUnionErrorMessage, __LINE__);
        }
        $this->LatestTimeOfDay = $latestTimeOfDay;
        return $this;
    }
    /**
     * Get LatestPeriod value
     * @return string|null
     */
    public function getLatestPeriod()
    {
        return $this->LatestPeriod;
    }
    /**
     * Set LatestPeriod value
     * @param string $latestPeriod
     * @return \StructType\AdvReservation
     */
    public function setLatestPeriod($latestPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($latestPeriod) && !is_string($latestPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestPeriod, true), gettype($latestPeriod)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,3})
        if (!is_null($latestPeriod) && !preg_match('/[0-9]{1,3}/', $latestPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,3}', var_export($latestPeriod, true)), __LINE__);
        }
        $this->LatestPeriod = $latestPeriod;
        return $this;
    }
    /**
     * Get LatestUnit value
     * @return string|null
     */
    public function getLatestUnit()
    {
        return $this->LatestUnit;
    }
    /**
     * Set LatestUnit value
     * @uses \EnumType\StayUnitType::valueIsValid()
     * @uses \EnumType\StayUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $latestUnit
     * @return \StructType\AdvReservation
     */
    public function setLatestUnit($latestUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StayUnitType::valueIsValid($latestUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StayUnitType', is_array($latestUnit) ? implode(', ', $latestUnit) : var_export($latestUnit, true), implode(', ', \EnumType\StayUnitType::getValidValues())), __LINE__);
        }
        $this->LatestUnit = $latestUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdvReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
