<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvResTicketing StructType
 * Meta information extracted from the WSDL
 * - documentation: Container for holding rules regarding advance reservation or ticketing restrictions.
 * @subpackage Structs
 */
class AdvResTicketing extends AdvResTicketingType
{
    /**
     * The FirstTicketDate
     * Meta information extracted from the WSDL
     * - documentation: The first date that a ticket may be issued for this fare. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $FirstTicketDate;
    /**
     * The LastTicketDate
     * Meta information extracted from the WSDL
     * - documentation: The last date that a ticket may be issued for this fare. | A construct to validate either a date or a dateTime value.
     * - union: date | dateTime
     * - use: optional
     * @var string
     */
    public $LastTicketDate;
    /**
     * Constructor method for AdvResTicketing
     * @uses AdvResTicketing::setFirstTicketDate()
     * @uses AdvResTicketing::setLastTicketDate()
     * @param string $firstTicketDate
     * @param string $lastTicketDate
     */
    public function __construct($firstTicketDate = null, $lastTicketDate = null)
    {
        $this
            ->setFirstTicketDate($firstTicketDate)
            ->setLastTicketDate($lastTicketDate);
    }
    /**
     * Get FirstTicketDate value
     * @return string|null
     */
    public function getFirstTicketDate()
    {
        return $this->FirstTicketDate;
    }
    /**
     * This method is responsible for validating the value passed to the setFirstTicketDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFirstTicketDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setFirstTicketDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFirstTicketDateForUnionConstraintsFromSetFirstTicketDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set FirstTicketDate value
     * @param string $firstTicketDate
     * @return \StructType\AdvResTicketing
     */
    public function setFirstTicketDate($firstTicketDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstTicketDate) && !is_string($firstTicketDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstTicketDate, true), gettype($firstTicketDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($firstTicketDateUnionErrorMessage = self::validateFirstTicketDateForUnionConstraintsFromSetFirstTicketDate($firstTicketDate))) {
            throw new \InvalidArgumentException($firstTicketDateUnionErrorMessage, __LINE__);
        }
        $this->FirstTicketDate = $firstTicketDate;
        return $this;
    }
    /**
     * Get LastTicketDate value
     * @return string|null
     */
    public function getLastTicketDate()
    {
        return $this->LastTicketDate;
    }
    /**
     * This method is responsible for validating the value passed to the setLastTicketDate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLastTicketDate method
     * This is a set of validation rules based on the union types associated to the property being set by the setLastTicketDate method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLastTicketDateForUnionConstraintsFromSetLastTicketDate($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set LastTicketDate value
     * @param string $lastTicketDate
     * @return \StructType\AdvResTicketing
     */
    public function setLastTicketDate($lastTicketDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastTicketDate) && !is_string($lastTicketDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastTicketDate, true), gettype($lastTicketDate)), __LINE__);
        }
        // validation for constraint: union(date, dateTime)
        if ('' !== ($lastTicketDateUnionErrorMessage = self::validateLastTicketDateForUnionConstraintsFromSetLastTicketDate($lastTicketDate))) {
            throw new \InvalidArgumentException($lastTicketDateUnionErrorMessage, __LINE__);
        }
        $this->LastTicketDate = $lastTicketDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdvResTicketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
