<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adjustment StructType
 * @subpackage Structs
 */
class Adjustment extends AbstractStructBase
{
    /**
     * The ReservationOriginatorCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ReservationOriginatorCode;
    /**
     * The ConfirmationID
     * Meta information extracted from the WSDL
     * - documentation: The confirmation ID number. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ConfirmationID;
    /**
     * The ReservationID
     * Meta information extracted from the WSDL
     * - documentation: The reservation ID number. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ReservationID;
    /**
     * The RoomInventoryCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $RoomInventoryCode;
    /**
     * The AdjustReason
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $AdjustReason;
    /**
     * The Sequence
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Sequence;
    /**
     * The InvValue
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $InvValue;
    /**
     * The PromotionCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $PromotionCode;
    /**
     * The PromotionVendorCode
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string[]
     */
    public $PromotionVendorCode;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * Constructor method for Adjustment
     * @uses Adjustment::setReservationOriginatorCode()
     * @uses Adjustment::setConfirmationID()
     * @uses Adjustment::setReservationID()
     * @uses Adjustment::setRoomInventoryCode()
     * @uses Adjustment::setAdjustReason()
     * @uses Adjustment::setSequence()
     * @uses Adjustment::setInvValue()
     * @uses Adjustment::setPromotionCode()
     * @uses Adjustment::setPromotionVendorCode()
     * @uses Adjustment::setStart()
     * @uses Adjustment::setDuration()
     * @uses Adjustment::setEnd()
     * @param string $reservationOriginatorCode
     * @param string $confirmationID
     * @param string $reservationID
     * @param string $roomInventoryCode
     * @param string $adjustReason
     * @param int $sequence
     * @param int $invValue
     * @param string $promotionCode
     * @param string[] $promotionVendorCode
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct($reservationOriginatorCode = null, $confirmationID = null, $reservationID = null, $roomInventoryCode = null, $adjustReason = null, $sequence = null, $invValue = null, $promotionCode = null, array $promotionVendorCode = array(), $start = null, $duration = null, $end = null)
    {
        $this
            ->setReservationOriginatorCode($reservationOriginatorCode)
            ->setConfirmationID($confirmationID)
            ->setReservationID($reservationID)
            ->setRoomInventoryCode($roomInventoryCode)
            ->setAdjustReason($adjustReason)
            ->setSequence($sequence)
            ->setInvValue($invValue)
            ->setPromotionCode($promotionCode)
            ->setPromotionVendorCode($promotionVendorCode)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get ReservationOriginatorCode value
     * @return string|null
     */
    public function getReservationOriginatorCode()
    {
        return $this->ReservationOriginatorCode;
    }
    /**
     * Set ReservationOriginatorCode value
     * @param string $reservationOriginatorCode
     * @return \StructType\Adjustment
     */
    public function setReservationOriginatorCode($reservationOriginatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($reservationOriginatorCode) && !is_string($reservationOriginatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationOriginatorCode, true), gettype($reservationOriginatorCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($reservationOriginatorCode) && mb_strlen($reservationOriginatorCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($reservationOriginatorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($reservationOriginatorCode) && mb_strlen($reservationOriginatorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($reservationOriginatorCode)), __LINE__);
        }
        $this->ReservationOriginatorCode = $reservationOriginatorCode;
        return $this;
    }
    /**
     * Get ConfirmationID value
     * @return string|null
     */
    public function getConfirmationID()
    {
        return $this->ConfirmationID;
    }
    /**
     * Set ConfirmationID value
     * @param string $confirmationID
     * @return \StructType\Adjustment
     */
    public function setConfirmationID($confirmationID = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationID) && !is_string($confirmationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationID, true), gettype($confirmationID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($confirmationID) && mb_strlen($confirmationID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($confirmationID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($confirmationID) && mb_strlen($confirmationID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($confirmationID)), __LINE__);
        }
        $this->ConfirmationID = $confirmationID;
        return $this;
    }
    /**
     * Get ReservationID value
     * @return string|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @param string $reservationID
     * @return \StructType\Adjustment
     */
    public function setReservationID($reservationID = null)
    {
        // validation for constraint: string
        if (!is_null($reservationID) && !is_string($reservationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationID, true), gettype($reservationID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($reservationID) && mb_strlen($reservationID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($reservationID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($reservationID) && mb_strlen($reservationID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($reservationID)), __LINE__);
        }
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Get RoomInventoryCode value
     * @return string|null
     */
    public function getRoomInventoryCode()
    {
        return $this->RoomInventoryCode;
    }
    /**
     * Set RoomInventoryCode value
     * @param string $roomInventoryCode
     * @return \StructType\Adjustment
     */
    public function setRoomInventoryCode($roomInventoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomInventoryCode) && !is_string($roomInventoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomInventoryCode, true), gettype($roomInventoryCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($roomInventoryCode) && mb_strlen($roomInventoryCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($roomInventoryCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($roomInventoryCode) && mb_strlen($roomInventoryCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($roomInventoryCode)), __LINE__);
        }
        $this->RoomInventoryCode = $roomInventoryCode;
        return $this;
    }
    /**
     * Get AdjustReason value
     * @return string|null
     */
    public function getAdjustReason()
    {
        return $this->AdjustReason;
    }
    /**
     * Set AdjustReason value
     * @param string $adjustReason
     * @return \StructType\Adjustment
     */
    public function setAdjustReason($adjustReason = null)
    {
        // validation for constraint: string
        if (!is_null($adjustReason) && !is_string($adjustReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adjustReason, true), gettype($adjustReason)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($adjustReason) && mb_strlen($adjustReason) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($adjustReason)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($adjustReason) && mb_strlen($adjustReason) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($adjustReason)), __LINE__);
        }
        $this->AdjustReason = $adjustReason;
        return $this;
    }
    /**
     * Get Sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->Sequence;
    }
    /**
     * Set Sequence value
     * @param int $sequence
     * @return \StructType\Adjustment
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !(is_int($sequence) || ctype_digit($sequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sequence, true), gettype($sequence)), __LINE__);
        }
        $this->Sequence = $sequence;
        return $this;
    }
    /**
     * Get InvValue value
     * @return int|null
     */
    public function getInvValue()
    {
        return $this->InvValue;
    }
    /**
     * Set InvValue value
     * @param int $invValue
     * @return \StructType\Adjustment
     */
    public function setInvValue($invValue = null)
    {
        // validation for constraint: int
        if (!is_null($invValue) && !(is_int($invValue) || ctype_digit($invValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invValue, true), gettype($invValue)), __LINE__);
        }
        $this->InvValue = $invValue;
        return $this;
    }
    /**
     * Get PromotionCode value
     * @return string|null
     */
    public function getPromotionCode()
    {
        return $this->PromotionCode;
    }
    /**
     * Set PromotionCode value
     * @param string $promotionCode
     * @return \StructType\Adjustment
     */
    public function setPromotionCode($promotionCode = null)
    {
        // validation for constraint: string
        if (!is_null($promotionCode) && !is_string($promotionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promotionCode, true), gettype($promotionCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($promotionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionCode) && mb_strlen($promotionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionCode)), __LINE__);
        }
        $this->PromotionCode = $promotionCode;
        return $this;
    }
    /**
     * Get PromotionVendorCode value
     * @return string[]|null
     */
    public function getPromotionVendorCode()
    {
        return $this->PromotionVendorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionVendorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionVendorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adjustmentPromotionVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($adjustmentPromotionVendorCodeItem)) {
                $invalidValues[] = is_object($adjustmentPromotionVendorCodeItem) ? get_class($adjustmentPromotionVendorCodeItem) : sprintf('%s(%s)', gettype($adjustmentPromotionVendorCodeItem), var_export($adjustmentPromotionVendorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionVendorCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionVendorCode value
     * @param string[] $promotionVendorCode
     * @return \StructType\Adjustment
     */
    public function setPromotionVendorCode(array $promotionVendorCode = array())
    {
        // validation for constraint: list
        if ('' !== ($promotionVendorCodeArrayErrorMessage = self::validatePromotionVendorCodeForArrayConstraintsFromSetPromotionVendorCode($promotionVendorCode))) {
            throw new \InvalidArgumentException($promotionVendorCodeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($promotionVendorCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($promotionVendorCode) && mb_strlen($promotionVendorCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($promotionVendorCode)), __LINE__);
        }
        $this->PromotionVendorCode = is_array($promotionVendorCode) ? implode(' ', $promotionVendorCode) : null;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\Adjustment
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\Adjustment
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\Adjustment
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Adjustment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
