<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Indicates whether or not this is the default address. | Information about an address that identifies a location for a specific purposes.
 * @subpackage Structs
 */
class AddressInfoType extends AddressType
{
    /**
     * The UseType
     * Meta information extracted from the WSDL
     * - documentation: Describes the use of the address (e.g. mailing, delivery, billing, etc.). Refer to OpenTravel Code List Address Use Type (AUT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $UseType;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Used elsewhere in the message to reference this specific address. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to
     * particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The DefaultInd
     * Meta information extracted from the WSDL
     * - documentation: false | When true, indicates a default value should be used.
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $DefaultInd;
    /**
     * Constructor method for AddressInfoType
     * @uses AddressInfoType::setUseType()
     * @uses AddressInfoType::setRPH()
     * @uses AddressInfoType::setDefaultInd()
     * @param string $useType
     * @param string $rPH
     * @param bool $defaultInd
     */
    public function __construct($useType = null, $rPH = null, $defaultInd = null)
    {
        $this
            ->setUseType($useType)
            ->setRPH($rPH)
            ->setDefaultInd($defaultInd);
    }
    /**
     * Get UseType value
     * @return string|null
     */
    public function getUseType()
    {
        return $this->UseType;
    }
    /**
     * Set UseType value
     * @param string $useType
     * @return \StructType\AddressInfoType
     */
    public function setUseType($useType = null)
    {
        // validation for constraint: string
        if (!is_null($useType) && !is_string($useType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($useType, true), gettype($useType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($useType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $useType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($useType, true)), __LINE__);
        }
        $this->UseType = $useType;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AddressInfoType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \StructType\AddressInfoType
     */
    public function setDefaultInd($defaultInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultInd, true), gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
