<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta information extracted from the WSDL
 * - documentation: Uses any part of address information, such as street name, postal code, or country code. | The first and last dates between which this address is in effect. | Detailed information on an address for the customer. | Address information
 * of the person traveling. | The address for vehicle delivery or collection, or for customer pickup or drop-off. | The address to which a deposit may be sent. | The ID attribute in this group is a unique identifying value assigned by the creating
 * system and may be used to reference a primary-key value within a database or in a particular implementation. | This is used to indicate that an item is obsolete.
 * @subpackage Structs
 */
class Address extends AddressType
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: Identifies a company.
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $CompanyName;
    /**
     * The AddresseeName
     * Meta information extracted from the WSDL
     * - documentation: Name of the person to whom this address relates. | The name of the reciever of the payment.
     * - minOccurs: 0
     * - use: optional
     * @var \StructType\PersonNameType
     */
    public $AddresseeName;
    /**
     * The ValidationStatus
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ValidationStatus;
    /**
     * The TransferAction
     * Meta information extracted from the WSDL
     * - documentation: Indicates under what conditions the element will be transfered to the booking.
     * - use: optional
     * @var string
     */
    public $TransferAction;
    /**
     * The ParentCompanyRef
     * Meta information extracted from the WSDL
     * - documentation: A reference to the company from which this element has been inherited. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ParentCompanyRef;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the starting date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ending date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the ExpireDate is the first day after the applicable period (e.g. when expire date is Oct 15 the last date of the period is Oct 14).
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * The SameCountryInd
     * Meta information extracted from the WSDL
     * - documentation: When true, only locations in the same country as the specified city's country should be selected.
     * - use: optional
     * @var bool
     */
    public $SameCountryInd;
    /**
     * The AddressSearchScope
     * @var string
     */
    public $AddressSearchScope;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The SiteID
     * Meta information extracted from the WSDL
     * - documentation: An identifier of a particular location used in place of address details. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $SiteID;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - documentation: This field is to provide a name for the site reference of the off location service. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $SiteName;
    /**
     * The Removal
     * @var bool
     */
    public $Removal;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $ID;
    /**
     * Constructor method for Address
     * @uses Address::setCompanyName()
     * @uses Address::setAddresseeName()
     * @uses Address::setValidationStatus()
     * @uses Address::setTransferAction()
     * @uses Address::setParentCompanyRef()
     * @uses Address::setEffectiveDate()
     * @uses Address::setExpireDate()
     * @uses Address::setExpireDateExclusiveIndicator()
     * @uses Address::setSameCountryInd()
     * @uses Address::setAddressSearchScope()
     * @uses Address::setOperation()
     * @uses Address::setSiteID()
     * @uses Address::setSiteName()
     * @uses Address::setRemoval()
     * @uses Address::setID()
     * @param \StructType\CompanyNameType $companyName
     * @param \StructType\PersonNameType $addresseeName
     * @param string $validationStatus
     * @param string $transferAction
     * @param string $parentCompanyRef
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     * @param bool $sameCountryInd
     * @param string $addressSearchScope
     * @param string $operation
     * @param string $siteID
     * @param string $siteName
     * @param bool $removal
     * @param string $iD
     */
    public function __construct(\StructType\CompanyNameType $companyName = null, \StructType\PersonNameType $addresseeName = null, $validationStatus = null, $transferAction = null, $parentCompanyRef = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null, $sameCountryInd = null, $addressSearchScope = null, $operation = null, $siteID = null, $siteName = null, $removal = null, $iD = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setAddresseeName($addresseeName)
            ->setValidationStatus($validationStatus)
            ->setTransferAction($transferAction)
            ->setParentCompanyRef($parentCompanyRef)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator)
            ->setSameCountryInd($sameCountryInd)
            ->setAddressSearchScope($addressSearchScope)
            ->setOperation($operation)
            ->setSiteID($siteID)
            ->setSiteName($siteName)
            ->setRemoval($removal)
            ->setID($iD);
    }
    /**
     * Get CompanyName value
     * @return \StructType\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \StructType\CompanyNameType $companyName
     * @return \StructType\Address
     */
    public function setCompanyName(\StructType\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get AddresseeName value
     * @return \StructType\PersonNameType|null
     */
    public function getAddresseeName()
    {
        return $this->AddresseeName;
    }
    /**
     * Set AddresseeName value
     * @param \StructType\PersonNameType $addresseeName
     * @return \StructType\Address
     */
    public function setAddresseeName(\StructType\PersonNameType $addresseeName = null)
    {
        $this->AddresseeName = $addresseeName;
        return $this;
    }
    /**
     * Get ValidationStatus value
     * @return string|null
     */
    public function getValidationStatus()
    {
        return $this->ValidationStatus;
    }
    /**
     * Set ValidationStatus value
     * @param string $validationStatus
     * @return \StructType\Address
     */
    public function setValidationStatus($validationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($validationStatus) && !is_string($validationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationStatus, true), gettype($validationStatus)), __LINE__);
        }
        $this->ValidationStatus = $validationStatus;
        return $this;
    }
    /**
     * Get TransferAction value
     * @return string|null
     */
    public function getTransferAction()
    {
        return $this->TransferAction;
    }
    /**
     * Set TransferAction value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferAction
     * @return \StructType\Address
     */
    public function setTransferAction($transferAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferAction) ? implode(', ', $transferAction) : var_export($transferAction, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferAction = $transferAction;
        return $this;
    }
    /**
     * Get ParentCompanyRef value
     * @return string|null
     */
    public function getParentCompanyRef()
    {
        return $this->ParentCompanyRef;
    }
    /**
     * Set ParentCompanyRef value
     * @param string $parentCompanyRef
     * @return \StructType\Address
     */
    public function setParentCompanyRef($parentCompanyRef = null)
    {
        // validation for constraint: string
        if (!is_null($parentCompanyRef) && !is_string($parentCompanyRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentCompanyRef, true), gettype($parentCompanyRef)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($parentCompanyRef) && mb_strlen($parentCompanyRef) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($parentCompanyRef)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($parentCompanyRef) && mb_strlen($parentCompanyRef) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($parentCompanyRef)), __LINE__);
        }
        $this->ParentCompanyRef = $parentCompanyRef;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Address
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\Address
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\Address
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Get SameCountryInd value
     * @return bool|null
     */
    public function getSameCountryInd()
    {
        return $this->SameCountryInd;
    }
    /**
     * Set SameCountryInd value
     * @param bool $sameCountryInd
     * @return \StructType\Address
     */
    public function setSameCountryInd($sameCountryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($sameCountryInd) && !is_bool($sameCountryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sameCountryInd, true), gettype($sameCountryInd)), __LINE__);
        }
        $this->SameCountryInd = $sameCountryInd;
        return $this;
    }
    /**
     * Get AddressSearchScope value
     * @return string|null
     */
    public function getAddressSearchScope()
    {
        return $this->AddressSearchScope;
    }
    /**
     * Set AddressSearchScope value
     * @param string $addressSearchScope
     * @return \StructType\Address
     */
    public function setAddressSearchScope($addressSearchScope = null)
    {
        // validation for constraint: string
        if (!is_null($addressSearchScope) && !is_string($addressSearchScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressSearchScope, true), gettype($addressSearchScope)), __LINE__);
        }
        $this->AddressSearchScope = $addressSearchScope;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\Address
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get SiteID value
     * @return string|null
     */
    public function getSiteID()
    {
        return $this->SiteID;
    }
    /**
     * Set SiteID value
     * @param string $siteID
     * @return \StructType\Address
     */
    public function setSiteID($siteID = null)
    {
        // validation for constraint: string
        if (!is_null($siteID) && !is_string($siteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteID, true), gettype($siteID)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($siteID) && mb_strlen($siteID) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($siteID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($siteID) && mb_strlen($siteID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($siteID)), __LINE__);
        }
        $this->SiteID = $siteID;
        return $this;
    }
    /**
     * Get SiteName value
     * @return string|null
     */
    public function getSiteName()
    {
        return $this->SiteName;
    }
    /**
     * Set SiteName value
     * @param string $siteName
     * @return \StructType\Address
     */
    public function setSiteName($siteName = null)
    {
        // validation for constraint: string
        if (!is_null($siteName) && !is_string($siteName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteName, true), gettype($siteName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($siteName) && mb_strlen($siteName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($siteName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($siteName) && mb_strlen($siteName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($siteName)), __LINE__);
        }
        $this->SiteName = $siteName;
        return $this;
    }
    /**
     * Get Removal value
     * @return bool|null
     */
    public function getRemoval()
    {
        return $this->Removal;
    }
    /**
     * Set Removal value
     * @param bool $removal
     * @return \StructType\Address
     */
    public function setRemoval($removal = null)
    {
        // validation for constraint: boolean
        if (!is_null($removal) && !is_bool($removal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removal, true), gettype($removal)), __LINE__);
        }
        $this->Removal = $removal;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Address
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($iD) && mb_strlen($iD) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($iD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD) && mb_strlen($iD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
