<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalRule StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides additional rules for the reservation. | Indicates an additional rule for the reservation (e.g., cancelable, modifiable or refundable).
 * @subpackage Structs
 */
class AdditionalRule extends AbstractStructBase
{
    /**
     * The AdditionalRule
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AdditionalRule;
    /**
     * Constructor method for AdditionalRule
     * @uses AdditionalRule::setAdditionalRule()
     * @param string $additionalRule
     */
    public function __construct($additionalRule = null)
    {
        $this
            ->setAdditionalRule($additionalRule);
    }
    /**
     * Get AdditionalRule value
     * @return string|null
     */
    public function getAdditionalRule()
    {
        return $this->AdditionalRule;
    }
    /**
     * Set AdditionalRule value
     * @param string $additionalRule
     * @return \StructType\AdditionalRule
     */
    public function setAdditionalRule($additionalRule = null)
    {
        // validation for constraint: string
        if (!is_null($additionalRule) && !is_string($additionalRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalRule, true), gettype($additionalRule)), __LINE__);
        }
        $this->AdditionalRule = $additionalRule;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
