<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalGuestAmountType StructType
 * Meta information extracted from the WSDL
 * - documentation: Charges related to additional guests.
 * @subpackage Structs
 */
class AdditionalGuestAmountType extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount charged for an additional guest.
     * @var \StructType\TotalType
     */
    public $Amount;
    /**
     * The AddlGuestAmtDescription
     * Meta information extracted from the WSDL
     * - documentation: Descriptive information regarding amounts charged for additional guests.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $AddlGuestAmtDescription;
    /**
     * The MaxAdditionalGuests
     * Meta information extracted from the WSDL
     * - documentation: Increase the base rate by the additional occupant amount for each additional occupant of the same age group up to this maximum number of occupants of this age group. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $MaxAdditionalGuests;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: A code representing the charges related to additional guests. Refer to OpenTravel Code List Additional Detail Type (ADT). Typically, the extra person information code would be used here. | Used for codes in the OpenTravel Code
     * tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: The percent charged for an additional guest. | Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: An index code to identify an instance in a collection of like items. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients
     * to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The AgeQualifyingCode
     * Meta information extracted from the WSDL
     * - documentation: Defines an age range or age category of a guest (e.g., under 21, over 65, teen, infant). Refer to OpenTravel Code List Age Qualifying Code (AQC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1,
     * 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * Meta information extracted from the WSDL
     * - documentation: MinAge: The minimum age to qualify for AgeQualifyingCode. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * Meta information extracted from the WSDL
     * - documentation: Max Age: The maximum age to qualify for AgeQualifyingCode. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * Meta information extracted from the WSDL
     * - documentation: TimeUnit : Qualifier for Age.
     * - type: TimeUnitType
     * - use: optional
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * Constructor method for AdditionalGuestAmountType
     * @uses AdditionalGuestAmountType::setAmount()
     * @uses AdditionalGuestAmountType::setAddlGuestAmtDescription()
     * @uses AdditionalGuestAmountType::setMaxAdditionalGuests()
     * @uses AdditionalGuestAmountType::setType()
     * @uses AdditionalGuestAmountType::setPercent()
     * @uses AdditionalGuestAmountType::setRPH()
     * @uses AdditionalGuestAmountType::setAgeQualifyingCode()
     * @uses AdditionalGuestAmountType::setMinAge()
     * @uses AdditionalGuestAmountType::setMaxAge()
     * @uses AdditionalGuestAmountType::setAgeTimeUnit()
     * @param \StructType\TotalType $amount
     * @param \StructType\ParagraphType[] $addlGuestAmtDescription
     * @param int $maxAdditionalGuests
     * @param string $type
     * @param float $percent
     * @param string $rPH
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     */
    public function __construct(\StructType\TotalType $amount = null, array $addlGuestAmtDescription = array(), $maxAdditionalGuests = null, $type = null, $percent = null, $rPH = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null)
    {
        $this
            ->setAmount($amount)
            ->setAddlGuestAmtDescription($addlGuestAmtDescription)
            ->setMaxAdditionalGuests($maxAdditionalGuests)
            ->setType($type)
            ->setPercent($percent)
            ->setRPH($rPH)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit);
    }
    /**
     * Get Amount value
     * @return \StructType\TotalType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\TotalType $amount
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setAmount(\StructType\TotalType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AddlGuestAmtDescription value
     * @return \StructType\ParagraphType[]|null
     */
    public function getAddlGuestAmtDescription()
    {
        return $this->AddlGuestAmtDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setAddlGuestAmtDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddlGuestAmtDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddlGuestAmtDescriptionForArrayConstraintsFromSetAddlGuestAmtDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalGuestAmountTypeAddlGuestAmtDescriptionItem) {
            // validation for constraint: itemType
            if (!$additionalGuestAmountTypeAddlGuestAmtDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($additionalGuestAmountTypeAddlGuestAmtDescriptionItem) ? get_class($additionalGuestAmountTypeAddlGuestAmtDescriptionItem) : sprintf('%s(%s)', gettype($additionalGuestAmountTypeAddlGuestAmtDescriptionItem), var_export($additionalGuestAmountTypeAddlGuestAmtDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddlGuestAmtDescription property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $addlGuestAmtDescription
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setAddlGuestAmtDescription(array $addlGuestAmtDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($addlGuestAmtDescriptionArrayErrorMessage = self::validateAddlGuestAmtDescriptionForArrayConstraintsFromSetAddlGuestAmtDescription($addlGuestAmtDescription))) {
            throw new \InvalidArgumentException($addlGuestAmtDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($addlGuestAmtDescription) && count($addlGuestAmtDescription) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($addlGuestAmtDescription)), __LINE__);
        }
        $this->AddlGuestAmtDescription = $addlGuestAmtDescription;
        return $this;
    }
    /**
     * Add item to AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\AdditionalGuestAmountType
     */
    public function addToAddlGuestAmtDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The AddlGuestAmtDescription property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->AddlGuestAmtDescription) && count($this->AddlGuestAmtDescription) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->AddlGuestAmtDescription)), __LINE__);
        }
        $this->AddlGuestAmtDescription[] = $item;
        return $this;
    }
    /**
     * Get MaxAdditionalGuests value
     * @return int|null
     */
    public function getMaxAdditionalGuests()
    {
        return $this->MaxAdditionalGuests;
    }
    /**
     * Set MaxAdditionalGuests value
     * @param int $maxAdditionalGuests
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setMaxAdditionalGuests($maxAdditionalGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdditionalGuests) && !(is_int($maxAdditionalGuests) || ctype_digit($maxAdditionalGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAdditionalGuests, true), gettype($maxAdditionalGuests)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($maxAdditionalGuests) && $maxAdditionalGuests > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($maxAdditionalGuests, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maxAdditionalGuests) && $maxAdditionalGuests < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maxAdditionalGuests, true)), __LINE__);
        }
        $this->MaxAdditionalGuests = $maxAdditionalGuests;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($type) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($type, true)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($percent) && $percent > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($percent, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($percent) && $percent < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($percent, true)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ageQualifyingCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ageQualifyingCode, true)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($minAge) && $minAge > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($minAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($minAge) && $minAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($minAge, true)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($maxAge) && $maxAge > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($maxAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maxAge) && $maxAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maxAge, true)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \StructType\AdditionalGuestAmountType
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($ageTimeUnit) ? implode(', ', $ageTimeUnit) : var_export($ageTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalGuestAmountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
