<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalGuestAmount StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of incremental charges per age qualifying code for additional guests. Amount charged for additional occupant is with respect to age group of the base guests.
 * @subpackage Structs
 */
class AdditionalGuestAmount extends AbstractStructBase
{
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxesType
     */
    public $Taxes;
    /**
     * The AddlGuestAmtDescription
     * Meta information extracted from the WSDL
     * - documentation: Text description of the AdditionalGuestAmount in a given language.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\ParagraphType[]
     */
    public $AddlGuestAmtDescription;
    /**
     * The TaxInclusive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether taxes are included when figuring the additional occupant amounts.
     * - use: optional
     * @var bool
     */
    public $TaxInclusive;
    /**
     * The MaxAdditionalGuests
     * Meta information extracted from the WSDL
     * - documentation: Increase the base rate by the additional occupant amount for each additional occupant of the same age group up to this maximum number of occupants of this age group. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - use: optional
     * @var int
     */
    public $MaxAdditionalGuests;
    /**
     * The AgeQualifyingCode
     * Meta information extracted from the WSDL
     * - documentation: Defines an age range or age category of a guest (e.g., under 21, over 65, teen, infant). Refer to OpenTravel Code List Age Qualifying Code (AQC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1,
     * 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $AgeQualifyingCode;
    /**
     * The MinAge
     * Meta information extracted from the WSDL
     * - documentation: MinAge: The minimum age to qualify for AgeQualifyingCode. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $MinAge;
    /**
     * The MaxAge
     * Meta information extracted from the WSDL
     * - documentation: Max Age: The maximum age to qualify for AgeQualifyingCode. | Used for Numeric values, from 1 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 1
     * - type: Numeric1to999
     * - use: optional
     * @var int
     */
    public $MaxAge;
    /**
     * The AgeTimeUnit
     * Meta information extracted from the WSDL
     * - documentation: TimeUnit : Qualifier for Age.
     * - type: TimeUnitType
     * - use: optional
     * @var string
     */
    public $AgeTimeUnit;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * @var string
     */
    public $Code;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * @var float
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for AdditionalGuestAmount
     * @uses AdditionalGuestAmount::setTaxes()
     * @uses AdditionalGuestAmount::setAddlGuestAmtDescription()
     * @uses AdditionalGuestAmount::setTaxInclusive()
     * @uses AdditionalGuestAmount::setMaxAdditionalGuests()
     * @uses AdditionalGuestAmount::setAgeQualifyingCode()
     * @uses AdditionalGuestAmount::setMinAge()
     * @uses AdditionalGuestAmount::setMaxAge()
     * @uses AdditionalGuestAmount::setAgeTimeUnit()
     * @uses AdditionalGuestAmount::setType()
     * @uses AdditionalGuestAmount::setCode()
     * @uses AdditionalGuestAmount::setPercent()
     * @uses AdditionalGuestAmount::setAmount()
     * @uses AdditionalGuestAmount::setCurrencyCode()
     * @uses AdditionalGuestAmount::setDecimalPlaces()
     * @param \StructType\TaxesType $taxes
     * @param \StructType\ParagraphType[] $addlGuestAmtDescription
     * @param bool $taxInclusive
     * @param int $maxAdditionalGuests
     * @param string $ageQualifyingCode
     * @param int $minAge
     * @param int $maxAge
     * @param string $ageTimeUnit
     * @param string $type
     * @param string $code
     * @param float $percent
     * @param float $amount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct(\StructType\TaxesType $taxes = null, array $addlGuestAmtDescription = array(), $taxInclusive = null, $maxAdditionalGuests = null, $ageQualifyingCode = null, $minAge = null, $maxAge = null, $ageTimeUnit = null, $type = null, $code = null, $percent = null, $amount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setTaxes($taxes)
            ->setAddlGuestAmtDescription($addlGuestAmtDescription)
            ->setTaxInclusive($taxInclusive)
            ->setMaxAdditionalGuests($maxAdditionalGuests)
            ->setAgeQualifyingCode($ageQualifyingCode)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setAgeTimeUnit($ageTimeUnit)
            ->setType($type)
            ->setCode($code)
            ->setPercent($percent)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get Taxes value
     * @return \StructType\TaxesType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\TaxesType $taxes
     * @return \StructType\AdditionalGuestAmount
     */
    public function setTaxes(\StructType\TaxesType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get AddlGuestAmtDescription value
     * @return \StructType\ParagraphType[]|null
     */
    public function getAddlGuestAmtDescription()
    {
        return $this->AddlGuestAmtDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setAddlGuestAmtDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddlGuestAmtDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddlGuestAmtDescriptionForArrayConstraintsFromSetAddlGuestAmtDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalGuestAmountAddlGuestAmtDescriptionItem) {
            // validation for constraint: itemType
            if (!$additionalGuestAmountAddlGuestAmtDescriptionItem instanceof \StructType\ParagraphType) {
                $invalidValues[] = is_object($additionalGuestAmountAddlGuestAmtDescriptionItem) ? get_class($additionalGuestAmountAddlGuestAmtDescriptionItem) : sprintf('%s(%s)', gettype($additionalGuestAmountAddlGuestAmtDescriptionItem), var_export($additionalGuestAmountAddlGuestAmtDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddlGuestAmtDescription property can only contain items of type \StructType\ParagraphType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType[] $addlGuestAmtDescription
     * @return \StructType\AdditionalGuestAmount
     */
    public function setAddlGuestAmtDescription(array $addlGuestAmtDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($addlGuestAmtDescriptionArrayErrorMessage = self::validateAddlGuestAmtDescriptionForArrayConstraintsFromSetAddlGuestAmtDescription($addlGuestAmtDescription))) {
            throw new \InvalidArgumentException($addlGuestAmtDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($addlGuestAmtDescription) && count($addlGuestAmtDescription) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($addlGuestAmtDescription)), __LINE__);
        }
        $this->AddlGuestAmtDescription = $addlGuestAmtDescription;
        return $this;
    }
    /**
     * Add item to AddlGuestAmtDescription value
     * @throws \InvalidArgumentException
     * @param \StructType\ParagraphType $item
     * @return \StructType\AdditionalGuestAmount
     */
    public function addToAddlGuestAmtDescription(\StructType\ParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParagraphType) {
            throw new \InvalidArgumentException(sprintf('The AddlGuestAmtDescription property can only contain items of type \StructType\ParagraphType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->AddlGuestAmtDescription) && count($this->AddlGuestAmtDescription) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->AddlGuestAmtDescription)), __LINE__);
        }
        $this->AddlGuestAmtDescription[] = $item;
        return $this;
    }
    /**
     * Get TaxInclusive value
     * @return bool|null
     */
    public function getTaxInclusive()
    {
        return $this->TaxInclusive;
    }
    /**
     * Set TaxInclusive value
     * @param bool $taxInclusive
     * @return \StructType\AdditionalGuestAmount
     */
    public function setTaxInclusive($taxInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusive) && !is_bool($taxInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxInclusive, true), gettype($taxInclusive)), __LINE__);
        }
        $this->TaxInclusive = $taxInclusive;
        return $this;
    }
    /**
     * Get MaxAdditionalGuests value
     * @return int|null
     */
    public function getMaxAdditionalGuests()
    {
        return $this->MaxAdditionalGuests;
    }
    /**
     * Set MaxAdditionalGuests value
     * @param int $maxAdditionalGuests
     * @return \StructType\AdditionalGuestAmount
     */
    public function setMaxAdditionalGuests($maxAdditionalGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maxAdditionalGuests) && !(is_int($maxAdditionalGuests) || ctype_digit($maxAdditionalGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAdditionalGuests, true), gettype($maxAdditionalGuests)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($maxAdditionalGuests) && $maxAdditionalGuests > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($maxAdditionalGuests, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maxAdditionalGuests) && $maxAdditionalGuests < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maxAdditionalGuests, true)), __LINE__);
        }
        $this->MaxAdditionalGuests = $maxAdditionalGuests;
        return $this;
    }
    /**
     * Get AgeQualifyingCode value
     * @return string|null
     */
    public function getAgeQualifyingCode()
    {
        return $this->AgeQualifyingCode;
    }
    /**
     * Set AgeQualifyingCode value
     * @param string $ageQualifyingCode
     * @return \StructType\AdditionalGuestAmount
     */
    public function setAgeQualifyingCode($ageQualifyingCode = null)
    {
        // validation for constraint: string
        if (!is_null($ageQualifyingCode) && !is_string($ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ageQualifyingCode, true), gettype($ageQualifyingCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($ageQualifyingCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $ageQualifyingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($ageQualifyingCode, true)), __LINE__);
        }
        $this->AgeQualifyingCode = $ageQualifyingCode;
        return $this;
    }
    /**
     * Get MinAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->MinAge;
    }
    /**
     * Set MinAge value
     * @param int $minAge
     * @return \StructType\AdditionalGuestAmount
     */
    public function setMinAge($minAge = null)
    {
        // validation for constraint: int
        if (!is_null($minAge) && !(is_int($minAge) || ctype_digit($minAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minAge, true), gettype($minAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($minAge) && $minAge > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($minAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($minAge) && $minAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($minAge, true)), __LINE__);
        }
        $this->MinAge = $minAge;
        return $this;
    }
    /**
     * Get MaxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->MaxAge;
    }
    /**
     * Set MaxAge value
     * @param int $maxAge
     * @return \StructType\AdditionalGuestAmount
     */
    public function setMaxAge($maxAge = null)
    {
        // validation for constraint: int
        if (!is_null($maxAge) && !(is_int($maxAge) || ctype_digit($maxAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAge, true), gettype($maxAge)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($maxAge) && $maxAge > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($maxAge, true)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($maxAge) && $maxAge < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($maxAge, true)), __LINE__);
        }
        $this->MaxAge = $maxAge;
        return $this;
    }
    /**
     * Get AgeTimeUnit value
     * @return string|null
     */
    public function getAgeTimeUnit()
    {
        return $this->AgeTimeUnit;
    }
    /**
     * Set AgeTimeUnit value
     * @uses \EnumType\TimeUnitType::valueIsValid()
     * @uses \EnumType\TimeUnitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageTimeUnit
     * @return \StructType\AdditionalGuestAmount
     */
    public function setAgeTimeUnit($ageTimeUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TimeUnitType::valueIsValid($ageTimeUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TimeUnitType', is_array($ageTimeUnit) ? implode(', ', $ageTimeUnit) : var_export($ageTimeUnit, true), implode(', ', \EnumType\TimeUnitType::getValidValues())), __LINE__);
        }
        $this->AgeTimeUnit = $ageTimeUnit;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\AmountDeterminationType::valueIsValid()
     * @uses \EnumType\AmountDeterminationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\AdditionalGuestAmount
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AmountDeterminationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AmountDeterminationType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\AmountDeterminationType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\AdditionalGuestAmount
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($code) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($code, true)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\AdditionalGuestAmount
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($percent) && $percent > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($percent, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($percent) && $percent < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($percent, true)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AdditionalGuestAmount
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AdditionalGuestAmount
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\AdditionalGuestAmount
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalGuestAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
