<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalCharge StructType
 * Meta information extracted from the WSDL
 * - documentation: Amenities or services to which a charge applies.
 * @subpackage Structs
 */
class AdditionalCharge extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount charged for an amenity or service.
     * - minOccurs: 0
     * @var \StructType\TotalType
     */
    public $Amount;
    /**
     * The RoomAmenityCode
     * Meta information extracted from the WSDL
     * - documentation: Identifes the types of room amenities to which a charge applies. Refer to OpenTravel Code List Room Amenity Type (RMA). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $RoomAmenityCode;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for AdditionalCharge
     * @uses AdditionalCharge::setAmount()
     * @uses AdditionalCharge::setRoomAmenityCode()
     * @uses AdditionalCharge::setQuantity()
     * @param \StructType\TotalType $amount
     * @param string $roomAmenityCode
     * @param int $quantity
     */
    public function __construct(\StructType\TotalType $amount = null, $roomAmenityCode = null, $quantity = null)
    {
        $this
            ->setAmount($amount)
            ->setRoomAmenityCode($roomAmenityCode)
            ->setQuantity($quantity);
    }
    /**
     * Get Amount value
     * @return \StructType\TotalType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\TotalType $amount
     * @return \StructType\AdditionalCharge
     */
    public function setAmount(\StructType\TotalType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get RoomAmenityCode value
     * @return string|null
     */
    public function getRoomAmenityCode()
    {
        return $this->RoomAmenityCode;
    }
    /**
     * Set RoomAmenityCode value
     * @param string $roomAmenityCode
     * @return \StructType\AdditionalCharge
     */
    public function setRoomAmenityCode($roomAmenityCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomAmenityCode) && !is_string($roomAmenityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomAmenityCode, true), gettype($roomAmenityCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($roomAmenityCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $roomAmenityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($roomAmenityCode, true)), __LINE__);
        }
        $this->RoomAmenityCode = $roomAmenityCode;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\AdditionalCharge
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
