<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Additional StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to define the specific type of additional person (Adult, YoungDriver, YoungerDriver, or it may be a code that is acceptable to both Trading Partners) | Specifies the dates for how long the additional driver should be part of the
 * rental contract. | Information on additional driver(s), possibly including frequent renter number.
 * @subpackage Structs
 */
class Additional extends CustomerType
{
    /**
     * The CorpDiscountName
     * Meta information extracted from the WSDL
     * - documentation: This is the name of the organization associated with the corporate discount number. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $CorpDiscountName;
    /**
     * The CorpDiscountNmbr
     * Meta information extracted from the WSDL
     * - documentation: This is the code used to identify if the additional driver is eligible for benefits associated with a specific organization. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $CorpDiscountNmbr;
    /**
     * The QualificationMethod
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $QualificationMethod;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Allows for the specification of a night duration.
     * - union: duration | NightDurationType
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: A construct to validate either a date or a time or a dateTime value.
     * - union: date | dateTime | time
     * @var string
     */
    public $End;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - documentation: Used for Numeric values, from 0 to 999 inclusive.
     * - base: xs:integer
     * - maxInclusive: 999
     * - minInclusive: 0
     * @var int
     */
    public $Age;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CodeContext;
    /**
     * The URI
     * @var string
     */
    public $URI;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for Additional
     * @uses Additional::setCorpDiscountName()
     * @uses Additional::setCorpDiscountNmbr()
     * @uses Additional::setQualificationMethod()
     * @uses Additional::setStart()
     * @uses Additional::setDuration()
     * @uses Additional::setEnd()
     * @uses Additional::setAge()
     * @uses Additional::setCode()
     * @uses Additional::setCodeContext()
     * @uses Additional::setURI()
     * @uses Additional::setQuantity()
     * @param string $corpDiscountName
     * @param string $corpDiscountNmbr
     * @param string $qualificationMethod
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param int $age
     * @param string $code
     * @param string $codeContext
     * @param string $uRI
     * @param int $quantity
     */
    public function __construct($corpDiscountName = null, $corpDiscountNmbr = null, $qualificationMethod = null, $start = null, $duration = null, $end = null, $age = null, $code = null, $codeContext = null, $uRI = null, $quantity = null)
    {
        $this
            ->setCorpDiscountName($corpDiscountName)
            ->setCorpDiscountNmbr($corpDiscountNmbr)
            ->setQualificationMethod($qualificationMethod)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setAge($age)
            ->setCode($code)
            ->setCodeContext($codeContext)
            ->setURI($uRI)
            ->setQuantity($quantity);
    }
    /**
     * Get CorpDiscountName value
     * @return string|null
     */
    public function getCorpDiscountName()
    {
        return $this->CorpDiscountName;
    }
    /**
     * Set CorpDiscountName value
     * @param string $corpDiscountName
     * @return \StructType\Additional
     */
    public function setCorpDiscountName($corpDiscountName = null)
    {
        // validation for constraint: string
        if (!is_null($corpDiscountName) && !is_string($corpDiscountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corpDiscountName, true), gettype($corpDiscountName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($corpDiscountName) && mb_strlen($corpDiscountName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($corpDiscountName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($corpDiscountName) && mb_strlen($corpDiscountName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($corpDiscountName)), __LINE__);
        }
        $this->CorpDiscountName = $corpDiscountName;
        return $this;
    }
    /**
     * Get CorpDiscountNmbr value
     * @return string|null
     */
    public function getCorpDiscountNmbr()
    {
        return $this->CorpDiscountNmbr;
    }
    /**
     * Set CorpDiscountNmbr value
     * @param string $corpDiscountNmbr
     * @return \StructType\Additional
     */
    public function setCorpDiscountNmbr($corpDiscountNmbr = null)
    {
        // validation for constraint: string
        if (!is_null($corpDiscountNmbr) && !is_string($corpDiscountNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($corpDiscountNmbr, true), gettype($corpDiscountNmbr)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($corpDiscountNmbr) && mb_strlen($corpDiscountNmbr) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($corpDiscountNmbr)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($corpDiscountNmbr) && mb_strlen($corpDiscountNmbr) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($corpDiscountNmbr)), __LINE__);
        }
        $this->CorpDiscountNmbr = $corpDiscountNmbr;
        return $this;
    }
    /**
     * Get QualificationMethod value
     * @return string|null
     */
    public function getQualificationMethod()
    {
        return $this->QualificationMethod;
    }
    /**
     * Set QualificationMethod value
     * @param string $qualificationMethod
     * @return \StructType\Additional
     */
    public function setQualificationMethod($qualificationMethod = null)
    {
        // validation for constraint: string
        if (!is_null($qualificationMethod) && !is_string($qualificationMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualificationMethod, true), gettype($qualificationMethod)), __LINE__);
        }
        $this->QualificationMethod = $qualificationMethod;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * This method is responsible for validating the value passed to the setStart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStart method
     * This is a set of validation rules based on the union types associated to the property being set by the setStart method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStartForUnionConstraintsFromSetStart($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\Additional
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($startUnionErrorMessage = self::validateStartForUnionConstraintsFromSetStart($start))) {
            throw new \InvalidArgumentException($startUnionErrorMessage, __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * This method is responsible for validating the value passed to the setDuration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDuration method
     * This is a set of validation rules based on the union types associated to the property being set by the setDuration method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurationForUnionConstraintsFromSetDuration($value)
    {
        $message = '';
        // validation for constraint: pattern(P[0-9]{1,3}N)
        if (!is_null($value) && !preg_match('/P[0-9]{1,3}N/', $value)) {
            $exception0 = new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression P[0-9]{1,3}N', var_export($value, true)), __LINE__);
        }
        if (isset($exception0)) {
            $message = sprintf("The value %s does not match any of the union rules: duration, NightDurationType. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [$exception0])));
        }
        unset($exception0);
        return $message;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\Additional
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        // validation for constraint: union(duration, NightDurationType)
        if ('' !== ($durationUnionErrorMessage = self::validateDurationForUnionConstraintsFromSetDuration($duration))) {
            throw new \InvalidArgumentException($durationUnionErrorMessage, __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * This method is responsible for validating the value passed to the setEnd method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnd method
     * This is a set of validation rules based on the union types associated to the property being set by the setEnd method
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEndForUnionConstraintsFromSetEnd($value)
    {
        $message = '';
        if () {
            $message = sprintf("The value %s does not match any of the union rules: date, dateTime, time. See following errors:\n%s", var_export($value, true), implode("\n", array_map(function(\InvalidArgumentException $e) { return sprintf(' - %s', $e->getMessage()); }, [])));
        }
        unset();
        return $message;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\Additional
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        // validation for constraint: union(date, dateTime, time)
        if ('' !== ($endUnionErrorMessage = self::validateEndForUnionConstraintsFromSetEnd($end))) {
            throw new \InvalidArgumentException($endUnionErrorMessage, __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\Additional
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        // validation for constraint: maxInclusive(999)
        if (!is_null($age) && $age > 999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 999', var_export($age, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($age) && $age < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($age, true)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Additional
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\Additional
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($codeContext) && mb_strlen($codeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($codeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeContext) && mb_strlen($codeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \StructType\Additional
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRI, true), gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\Additional
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Additional
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
