<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountInformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to back office accounting information for the travel agency.
 * @subpackage Structs
 */
class AccountInformation extends AbstractStructBase
{
    /**
     * The TaxRegistrationDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxRegistrationDetails
     */
    public $TaxRegistrationDetails;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: Ticketing account number. | Used for Character Strings, length 0 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The CostCenter
     * Meta information extracted from the WSDL
     * - documentation: Ticketing cost center. | Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $CostCenter;
    /**
     * The CompanyNumber
     * Meta information extracted from the WSDL
     * - documentation: Ticketing company number. | Used for Character Strings, length 0 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $CompanyNumber;
    /**
     * The ClientReference
     * Meta information extracted from the WSDL
     * - documentation: Ticketing client reference. | Used for Character Strings, length 0 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 0
     * - use: optional
     * @var string
     */
    public $ClientReference;
    /**
     * Constructor method for AccountInformation
     * @uses AccountInformation::setTaxRegistrationDetails()
     * @uses AccountInformation::setNumber()
     * @uses AccountInformation::setCostCenter()
     * @uses AccountInformation::setCompanyNumber()
     * @uses AccountInformation::setClientReference()
     * @param \StructType\TaxRegistrationDetails $taxRegistrationDetails
     * @param string $number
     * @param string $costCenter
     * @param string $companyNumber
     * @param string $clientReference
     */
    public function __construct(\StructType\TaxRegistrationDetails $taxRegistrationDetails = null, $number = null, $costCenter = null, $companyNumber = null, $clientReference = null)
    {
        $this
            ->setTaxRegistrationDetails($taxRegistrationDetails)
            ->setNumber($number)
            ->setCostCenter($costCenter)
            ->setCompanyNumber($companyNumber)
            ->setClientReference($clientReference);
    }
    /**
     * Get TaxRegistrationDetails value
     * @return \StructType\TaxRegistrationDetails|null
     */
    public function getTaxRegistrationDetails()
    {
        return $this->TaxRegistrationDetails;
    }
    /**
     * Set TaxRegistrationDetails value
     * @param \StructType\TaxRegistrationDetails $taxRegistrationDetails
     * @return \StructType\AccountInformation
     */
    public function setTaxRegistrationDetails(\StructType\TaxRegistrationDetails $taxRegistrationDetails = null)
    {
        $this->TaxRegistrationDetails = $taxRegistrationDetails;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\AccountInformation
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($number) && mb_strlen($number) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($number)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($number) && mb_strlen($number) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get CostCenter value
     * @return string|null
     */
    public function getCostCenter()
    {
        return $this->CostCenter;
    }
    /**
     * Set CostCenter value
     * @param string $costCenter
     * @return \StructType\AccountInformation
     */
    public function setCostCenter($costCenter = null)
    {
        // validation for constraint: string
        if (!is_null($costCenter) && !is_string($costCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costCenter, true), gettype($costCenter)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($costCenter) && mb_strlen($costCenter) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($costCenter)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($costCenter) && mb_strlen($costCenter) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($costCenter)), __LINE__);
        }
        $this->CostCenter = $costCenter;
        return $this;
    }
    /**
     * Get CompanyNumber value
     * @return string|null
     */
    public function getCompanyNumber()
    {
        return $this->CompanyNumber;
    }
    /**
     * Set CompanyNumber value
     * @param string $companyNumber
     * @return \StructType\AccountInformation
     */
    public function setCompanyNumber($companyNumber = null)
    {
        // validation for constraint: string
        if (!is_null($companyNumber) && !is_string($companyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyNumber, true), gettype($companyNumber)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($companyNumber) && mb_strlen($companyNumber) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($companyNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($companyNumber) && mb_strlen($companyNumber) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($companyNumber)), __LINE__);
        }
        $this->CompanyNumber = $companyNumber;
        return $this;
    }
    /**
     * Get ClientReference value
     * @return string|null
     */
    public function getClientReference()
    {
        return $this->ClientReference;
    }
    /**
     * Set ClientReference value
     * @param string $clientReference
     * @return \StructType\AccountInformation
     */
    public function setClientReference($clientReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientReference) && !is_string($clientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientReference, true), gettype($clientReference)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($clientReference) && mb_strlen($clientReference) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($clientReference)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($clientReference) && mb_strlen($clientReference) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($clientReference)), __LINE__);
        }
        $this->ClientReference = $clientReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
