<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptablePaymentCard StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides the information needed to describe a type of payment card that is acceptable as a form of payment. A usage fee (amount or percentage) may also be stated for this particular card type. | Specific information of one payment
 * card that is acceptable as a form of payment.
 * @subpackage Structs
 */
class AcceptablePaymentCard extends AbstractStructBase
{
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - documentation: A code used to identify this payment card. Refer to OpenTravel Code List Card Type (CDT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $CardType;
    /**
     * The CardName
     * Meta information extracted from the WSDL
     * - documentation: The name used to describe this type of payment card, for example, American Express. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $CardName;
    /**
     * The UsagePercentage
     * Meta information extracted from the WSDL
     * - documentation: If applicable, defines the percentage of the total amount that is incurred as a usage fee. | Used for percentage values.
     * - base: xs:decimal
     * - maxInclusive: 100.00
     * - minInclusive: 0.00
     * - type: Percentage
     * - use: optional
     * @var float
     */
    public $UsagePercentage;
    /**
     * The UsageAmount
     * Meta information extracted from the WSDL
     * - documentation: If applicable, defines the additonal amount that is incurred as a usage fee. | Specifies an amount, max 3 decimals.
     * - base: xs:decimal
     * - fractionDigits: 3
     * - type: Money
     * - use: optional
     * @var float
     */
    public $UsageAmount;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: The code specifying a monetary unit. Use ISO 4217, three alpha code. | Used for an Alpha String, length exactly 3.
     * - base: xs:string
     * - pattern: [a-zA-Z]{3}
     * - type: AlphaLength3
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * Meta information extracted from the WSDL
     * - documentation: Indicates the number of decimal places for a particular currency. This is equivalent to the ISO 4217 standard "minor unit". Typically used when the amount provided includes the minor unit of currency without a decimal point (e.g.,
     * USD 8500 needs DecimalPlaces="2" to represent $85).
     * - type: xs:nonNegativeInteger
     * - use: optional
     * @var int
     */
    public $DecimalPlaces;
    /**
     * Constructor method for AcceptablePaymentCard
     * @uses AcceptablePaymentCard::setCardType()
     * @uses AcceptablePaymentCard::setCardName()
     * @uses AcceptablePaymentCard::setUsagePercentage()
     * @uses AcceptablePaymentCard::setUsageAmount()
     * @uses AcceptablePaymentCard::setCurrencyCode()
     * @uses AcceptablePaymentCard::setDecimalPlaces()
     * @param string $cardType
     * @param string $cardName
     * @param float $usagePercentage
     * @param float $usageAmount
     * @param string $currencyCode
     * @param int $decimalPlaces
     */
    public function __construct($cardType = null, $cardName = null, $usagePercentage = null, $usageAmount = null, $currencyCode = null, $decimalPlaces = null)
    {
        $this
            ->setCardType($cardType)
            ->setCardName($cardName)
            ->setUsagePercentage($usagePercentage)
            ->setUsageAmount($usageAmount)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces);
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @param string $cardType
     * @return \StructType\AcceptablePaymentCard
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($cardType) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($cardType, true)), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get CardName value
     * @return string|null
     */
    public function getCardName()
    {
        return $this->CardName;
    }
    /**
     * Set CardName value
     * @param string $cardName
     * @return \StructType\AcceptablePaymentCard
     */
    public function setCardName($cardName = null)
    {
        // validation for constraint: string
        if (!is_null($cardName) && !is_string($cardName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardName, true), gettype($cardName)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($cardName) && mb_strlen($cardName) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($cardName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($cardName) && mb_strlen($cardName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($cardName)), __LINE__);
        }
        $this->CardName = $cardName;
        return $this;
    }
    /**
     * Get UsagePercentage value
     * @return float|null
     */
    public function getUsagePercentage()
    {
        return $this->UsagePercentage;
    }
    /**
     * Set UsagePercentage value
     * @param float $usagePercentage
     * @return \StructType\AcceptablePaymentCard
     */
    public function setUsagePercentage($usagePercentage = null)
    {
        // validation for constraint: float
        if (!is_null($usagePercentage) && !(is_float($usagePercentage) || is_numeric($usagePercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($usagePercentage, true), gettype($usagePercentage)), __LINE__);
        }
        // validation for constraint: maxInclusive(100.00)
        if (!is_null($usagePercentage) && $usagePercentage > 100.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 100.00', var_export($usagePercentage, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.00)
        if (!is_null($usagePercentage) && $usagePercentage < 0.00) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.00', var_export($usagePercentage, true)), __LINE__);
        }
        $this->UsagePercentage = $usagePercentage;
        return $this;
    }
    /**
     * Get UsageAmount value
     * @return float|null
     */
    public function getUsageAmount()
    {
        return $this->UsageAmount;
    }
    /**
     * Set UsageAmount value
     * @param float $usageAmount
     * @return \StructType\AcceptablePaymentCard
     */
    public function setUsageAmount($usageAmount = null)
    {
        // validation for constraint: float
        if (!is_null($usageAmount) && !(is_float($usageAmount) || is_numeric($usageAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($usageAmount, true), gettype($usageAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($usageAmount) && mb_strlen(mb_substr($usageAmount, mb_strpos($usageAmount, '.') + 1)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($usageAmount, true), mb_strlen(mb_substr($usageAmount, mb_strpos($usageAmount, '.') + 1))), __LINE__);
        }
        $this->UsageAmount = $usageAmount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\AcceptablePaymentCard
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z]{3})
        if (!is_null($currencyCode) && !preg_match('/[a-zA-Z]{3}/', $currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z]{3}', var_export($currencyCode, true)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \StructType\AcceptablePaymentCard
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !(is_int($decimalPlaces) || ctype_digit($decimalPlaces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($decimalPlaces, true), gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AcceptablePaymentCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
