<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Request ServiceType
 * @subpackage Services
 */
class Request extends AbstractSoapClientBase
{
    /**
     * Sets the Security SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\SecurityHeaderType $security
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSecurity(\StructType\SecurityHeaderType $security, $nameSpace = 'http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Security', $security, $mustUnderstand, $actor);
    }
    /**
     * Sets the MessageID SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AttributedURI $messageID
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMessageID(\StructType\AttributedURI $messageID, $nameSpace = 'http://schemas.xmlsoap.org/ws/2004/08/addressing', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MessageID', $messageID, $mustUnderstand, $actor);
    }
    /**
     * Sets the To SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AttributedURI $to
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderTo(\StructType\AttributedURI $to, $nameSpace = 'http://schemas.xmlsoap.org/ws/2004/08/addressing', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'To', $to, $mustUnderstand, $actor);
    }
    /**
     * Sets the From SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\EndpointReferenceType $from
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderFrom(\StructType\EndpointReferenceType $from, $nameSpace = 'http://schemas.xmlsoap.org/ws/2004/08/addressing', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'From', $from, $mustUnderstand, $actor);
    }
    /**
     * Sets the Action SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\AttributedURI $action
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAction(\StructType\AttributedURI $action, $nameSpace = 'http://schemas.xmlsoap.org/ws/2004/08/addressing', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Action', $action, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named RequestAvailability
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Security, MessageID, To, From, Action
     * - SOAPHeaderNamespaces: http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd, http://schemas.xmlsoap.org/ws/2004/08/addressing, http://schemas.xmlsoap.org/ws/2004/08/addressing, http://schemas.xmlsoap.org/ws/2004/08/addressing, http://schemas.xmlsoap.org/ws/2004/08/addressing
     * - SOAPHeaderTypes: \StructType\SecurityHeaderType, \StructType\AttributedURI, \StructType\AttributedURI, \StructType\EndpointReferenceType, \StructType\AttributedURI
     * - SOAPHeaders: required, required, required, required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OTA_HotelAvailRQ $oTA_HotelAvailRQ
     * @return \StructType\OTA_HotelAvailRS|bool
     */
    public function RequestAvailability(\StructType\OTA_HotelAvailRQ $oTA_HotelAvailRQ)
    {
        try {
            $this->setResult($this->getSoapClient()->RequestAvailability($oTA_HotelAvailRQ));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OTA_HotelAvailRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
