<?php

namespace EnumType;

/**
 * This class stands for RelationshipTypeValues EnumType
 * @subpackage Enumerations
 */
class RelationshipTypeValues
{
    /**
     * Constant for value 'wsa:Reply'
     * @return string 'wsa:Reply'
     */
    const VALUE_WSA_REPLY = 'wsa:Reply';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WSA_REPLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WSA_REPLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
