<?php

namespace EnumType;

/**
 * This class stands for AirTripType EnumType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the trip type - one way, return, circle trip, open jaw.
 * @subpackage Enumerations
 */
class AirTripType
{
    /**
     * Constant for value 'OneWay'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a one way trip type.
     * @return string 'OneWay'
     */
    const VALUE_ONE_WAY = 'OneWay';
    /**
     * Constant for value 'OneWayOnly'
     * Meta information extracted from the WSDL
     * - documentation: Cannot be doubled to create a roundtrip.
     * @return string 'OneWayOnly'
     */
    const VALUE_ONE_WAY_ONLY = 'OneWayOnly';
    /**
     * Constant for value 'Return'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a return trip type.
     * @return string 'Return'
     */
    const VALUE_RETURN = 'Return';
    /**
     * Constant for value 'Circle'
     * Meta information extracted from the WSDL
     * - documentation: Identifies a circle trip type.
     * @return string 'Circle'
     */
    const VALUE_CIRCLE = 'Circle';
    /**
     * Constant for value 'OpenJaw'
     * Meta information extracted from the WSDL
     * - documentation: Identifies an open jaw trip type.
     * @return string 'OpenJaw'
     */
    const VALUE_OPEN_JAW = 'OpenJaw';
    /**
     * Constant for value 'Other'
     * Meta information extracted from the WSDL
     * - documentation: Identifies an other trip type.
     * @return string 'Other'
     */
    const VALUE_OTHER = 'Other';
    /**
     * Constant for value 'Outbound'
     * Meta information extracted from the WSDL
     * - documentation: The direction for the fare is outbound.
     * @return string 'Outbound'
     */
    const VALUE_OUTBOUND = 'Outbound';
    /**
     * Constant for value 'OutboundSeasonRoundtrip'
     * Meta information extracted from the WSDL
     * - documentation: The direction for the fare is outbound seasonal roundtrip.
     * @return string 'OutboundSeasonRoundtrip'
     */
    const VALUE_OUTBOUND_SEASON_ROUNDTRIP = 'OutboundSeasonRoundtrip';
    /**
     * Constant for value 'Non-directional'
     * Meta information extracted from the WSDL
     * - documentation: There is no direction specified for the fare.
     * @return string 'Non-directional'
     */
    const VALUE_NON_DIRECTIONAL = 'Non-directional';
    /**
     * Constant for value 'Inbound'
     * Meta information extracted from the WSDL
     * - documentation: The direction for the fare is inbound.
     * @return string 'Inbound'
     */
    const VALUE_INBOUND = 'Inbound';
    /**
     * Constant for value 'Roundtrip'
     * Meta information extracted from the WSDL
     * - documentation: Identifies travel from one point to another point and return to the original point. (The outbound fare shall be used also for the inbound fare component for the purpose of determing if the pricing unit is a round trip).
     * @return string 'Roundtrip'
     */
    const VALUE_ROUNDTRIP = 'Roundtrip';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONE_WAY
     * @uses self::VALUE_ONE_WAY_ONLY
     * @uses self::VALUE_RETURN
     * @uses self::VALUE_CIRCLE
     * @uses self::VALUE_OPEN_JAW
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_OUTBOUND
     * @uses self::VALUE_OUTBOUND_SEASON_ROUNDTRIP
     * @uses self::VALUE_NON_DIRECTIONAL
     * @uses self::VALUE_INBOUND
     * @uses self::VALUE_ROUNDTRIP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONE_WAY,
            self::VALUE_ONE_WAY_ONLY,
            self::VALUE_RETURN,
            self::VALUE_CIRCLE,
            self::VALUE_OPEN_JAW,
            self::VALUE_OTHER,
            self::VALUE_OUTBOUND,
            self::VALUE_OUTBOUND_SEASON_ROUNDTRIP,
            self::VALUE_NON_DIRECTIONAL,
            self::VALUE_INBOUND,
            self::VALUE_ROUNDTRIP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
