<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarningType StructType
 * Meta information extracted from the WSDL
 * - documentation: Details of the warning. | Used when a message has been successfully processed to report any warnings or business errors that occurred.
 * @subpackage Structs
 */
class WarningType extends FreeTextType
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: The Warning element MUST contain the Type attribute that uses a recommended set of values to indicate the warning type. The validating XSD can expect to accept values that it has NOT been explicitly coded for and process them by
     * using Type ="Unknown". Refer to OpenTravel Code List Error Warning Type (EWT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The _
     * @var \StructType\FreeTextType
     */
    public $_;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Reference Place Holder used as an index for this warning. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to
     * particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The ShortText
     * Meta information extracted from the WSDL
     * - documentation: An abbreviated version of the error in textual format. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $ShortText;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: If present, this refers to a table of coded values exchanged between applications to identify errors or warnings. Refer to OpenTravel Code List Error Codes (ERR). | Used for codes in the OpenTravel Code tables. Possible values of
     * this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The DocURL
     * Meta information extracted from the WSDL
     * - documentation: If present, this URL refers to an online description of the error that occurred.
     * - type: xs:anyURI
     * - use: optional
     * @var string
     */
    public $DocURL;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: If present, recommended values are those enumerated in the OTA_ErrorRS, (NotProcessed | Incomplete | Complete | Unknown) however, the data type is designated as string data, recognizing that trading partners may identify additional
     * status conditions not included in the enumeration. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Tag
     * Meta information extracted from the WSDL
     * - documentation: If present, this attribute may identify an unknown or misspelled tag that caused an error in processing. It is recommended that the Tag attribute use XPath notation to identify the location of a tag in the event that more than one
     * tag of the same name is present in the document. Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Tag;
    /**
     * The RecordID
     * Meta information extracted from the WSDL
     * - documentation: If present, this attribute allows for batch processing and the identification of the record that failed amongst a group of records. This value may contain a concatenation of a unique failed transaction ID with specific record(s)
     * associated with that transaction. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $RecordID;
    /**
     * Constructor method for WarningType
     * @uses WarningType::setType()
     * @uses WarningType::set_()
     * @uses WarningType::setRPH()
     * @uses WarningType::setShortText()
     * @uses WarningType::setCode()
     * @uses WarningType::setDocURL()
     * @uses WarningType::setStatus()
     * @uses WarningType::setTag()
     * @uses WarningType::setRecordID()
     * @param string $type
     * @param \StructType\FreeTextType $_
     * @param string $rPH
     * @param string $shortText
     * @param string $code
     * @param string $docURL
     * @param string $status
     * @param string $tag
     * @param string $recordID
     */
    public function __construct($type = null, \StructType\FreeTextType $_ = null, $rPH = null, $shortText = null, $code = null, $docURL = null, $status = null, $tag = null, $recordID = null)
    {
        $this
            ->setType($type)
            ->set_($_)
            ->setRPH($rPH)
            ->setShortText($shortText)
            ->setCode($code)
            ->setDocURL($docURL)
            ->setStatus($status)
            ->setTag($tag)
            ->setRecordID($recordID);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\WarningType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($type) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($type, true)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get _ value
     * @return \StructType\FreeTextType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\FreeTextType $_
     * @return \StructType\WarningType
     */
    public function set_(\StructType\FreeTextType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\WarningType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get ShortText value
     * @return string|null
     */
    public function getShortText()
    {
        return $this->ShortText;
    }
    /**
     * Set ShortText value
     * @param string $shortText
     * @return \StructType\WarningType
     */
    public function setShortText($shortText = null)
    {
        // validation for constraint: string
        if (!is_null($shortText) && !is_string($shortText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortText, true), gettype($shortText)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($shortText) && mb_strlen($shortText) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($shortText)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($shortText) && mb_strlen($shortText) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($shortText)), __LINE__);
        }
        $this->ShortText = $shortText;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\WarningType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($code) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($code, true)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DocURL value
     * @return string|null
     */
    public function getDocURL()
    {
        return $this->DocURL;
    }
    /**
     * Set DocURL value
     * @param string $docURL
     * @return \StructType\WarningType
     */
    public function setDocURL($docURL = null)
    {
        // validation for constraint: string
        if (!is_null($docURL) && !is_string($docURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docURL, true), gettype($docURL)), __LINE__);
        }
        $this->DocURL = $docURL;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\WarningType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($status) && mb_strlen($status) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($status)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($status) && mb_strlen($status) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Tag value
     * @return string|null
     */
    public function getTag()
    {
        return $this->Tag;
    }
    /**
     * Set Tag value
     * @param string $tag
     * @return \StructType\WarningType
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tag, true), gettype($tag)), __LINE__);
        }
        $this->Tag = $tag;
        return $this;
    }
    /**
     * Get RecordID value
     * @return string|null
     */
    public function getRecordID()
    {
        return $this->RecordID;
    }
    /**
     * Set RecordID value
     * @param string $recordID
     * @return \StructType\WarningType
     */
    public function setRecordID($recordID = null)
    {
        // validation for constraint: string
        if (!is_null($recordID) && !is_string($recordID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recordID, true), gettype($recordID)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($recordID) && mb_strlen($recordID) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($recordID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($recordID) && mb_strlen($recordID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($recordID)), __LINE__);
        }
        $this->RecordID = $recordID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WarningType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
