<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Voucher StructType
 * Meta information extracted from the WSDL
 * - documentation: The effective date, expiry date and series code of the voucher. | Details of a paper or electronic document indicating prepayment.
 * @subpackage Structs
 */
class Voucher extends AbstractStructBase
{
    /**
     * The BillingNumber
     * Meta information extracted from the WSDL
     * - documentation: Reference of the billing account which handles the payment transaction. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $BillingNumber;
    /**
     * The SupplierIdentifier
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of the electronic voucher, created by the supplier. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $SupplierIdentifier;
    /**
     * The Identifier
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier of the electronic voucher. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Identifier;
    /**
     * The ValueType
     * Meta information extracted from the WSDL
     * - documentation: Defines the type of voucher (e.g., full credit or partial credit). | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ValueType;
    /**
     * The ElectronicIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the voucher is electronic. An E-voucher is a value document issued by the Travel Agent for the customer. The e-voucher can be used as a proof of reservation, but more normally, as a full-payment or partial
     * payment.
     * - use: optional
     * @var bool
     */
    public $ElectronicIndicator;
    /**
     * The SeriesCode
     * Meta information extracted from the WSDL
     * - documentation: Identification of a series of coupons or vouchers identified by serial number(s). | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * @var string
     */
    public $SeriesCode;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the starting date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: Indicates the ending date.
     * - type: xs:date
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates that the ExpireDate is the first day after the applicable period (e.g. when expire date is Oct 15 the last date of the period is Oct 14).
     * - type: xs:boolean
     * - use: optional
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * Constructor method for Voucher
     * @uses Voucher::setBillingNumber()
     * @uses Voucher::setSupplierIdentifier()
     * @uses Voucher::setIdentifier()
     * @uses Voucher::setValueType()
     * @uses Voucher::setElectronicIndicator()
     * @uses Voucher::setSeriesCode()
     * @uses Voucher::setEffectiveDate()
     * @uses Voucher::setExpireDate()
     * @uses Voucher::setExpireDateExclusiveIndicator()
     * @param string $billingNumber
     * @param string $supplierIdentifier
     * @param string $identifier
     * @param string $valueType
     * @param bool $electronicIndicator
     * @param string $seriesCode
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     */
    public function __construct($billingNumber = null, $supplierIdentifier = null, $identifier = null, $valueType = null, $electronicIndicator = null, $seriesCode = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null)
    {
        $this
            ->setBillingNumber($billingNumber)
            ->setSupplierIdentifier($supplierIdentifier)
            ->setIdentifier($identifier)
            ->setValueType($valueType)
            ->setElectronicIndicator($electronicIndicator)
            ->setSeriesCode($seriesCode)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator);
    }
    /**
     * Get BillingNumber value
     * @return string|null
     */
    public function getBillingNumber()
    {
        return $this->BillingNumber;
    }
    /**
     * Set BillingNumber value
     * @param string $billingNumber
     * @return \StructType\Voucher
     */
    public function setBillingNumber($billingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($billingNumber) && !is_string($billingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingNumber, true), gettype($billingNumber)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($billingNumber) && mb_strlen($billingNumber) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($billingNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($billingNumber) && mb_strlen($billingNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($billingNumber)), __LINE__);
        }
        $this->BillingNumber = $billingNumber;
        return $this;
    }
    /**
     * Get SupplierIdentifier value
     * @return string|null
     */
    public function getSupplierIdentifier()
    {
        return $this->SupplierIdentifier;
    }
    /**
     * Set SupplierIdentifier value
     * @param string $supplierIdentifier
     * @return \StructType\Voucher
     */
    public function setSupplierIdentifier($supplierIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplierIdentifier) && !is_string($supplierIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierIdentifier, true), gettype($supplierIdentifier)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($supplierIdentifier) && mb_strlen($supplierIdentifier) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($supplierIdentifier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($supplierIdentifier) && mb_strlen($supplierIdentifier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($supplierIdentifier)), __LINE__);
        }
        $this->SupplierIdentifier = $supplierIdentifier;
        return $this;
    }
    /**
     * Get Identifier value
     * @return string|null
     */
    public function getIdentifier()
    {
        return $this->Identifier;
    }
    /**
     * Set Identifier value
     * @param string $identifier
     * @return \StructType\Voucher
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($identifier) && mb_strlen($identifier) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($identifier)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($identifier) && mb_strlen($identifier) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($identifier)), __LINE__);
        }
        $this->Identifier = $identifier;
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @param string $valueType
     * @return \StructType\Voucher
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: string
        if (!is_null($valueType) && !is_string($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueType, true), gettype($valueType)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($valueType) && mb_strlen($valueType) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($valueType)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($valueType) && mb_strlen($valueType) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($valueType)), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
    /**
     * Get ElectronicIndicator value
     * @return bool|null
     */
    public function getElectronicIndicator()
    {
        return $this->ElectronicIndicator;
    }
    /**
     * Set ElectronicIndicator value
     * @param bool $electronicIndicator
     * @return \StructType\Voucher
     */
    public function setElectronicIndicator($electronicIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($electronicIndicator) && !is_bool($electronicIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($electronicIndicator, true), gettype($electronicIndicator)), __LINE__);
        }
        $this->ElectronicIndicator = $electronicIndicator;
        return $this;
    }
    /**
     * Get SeriesCode value
     * @return string|null
     */
    public function getSeriesCode()
    {
        return $this->SeriesCode;
    }
    /**
     * Set SeriesCode value
     * @param string $seriesCode
     * @return \StructType\Voucher
     */
    public function setSeriesCode($seriesCode = null)
    {
        // validation for constraint: string
        if (!is_null($seriesCode) && !is_string($seriesCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesCode, true), gettype($seriesCode)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($seriesCode) && mb_strlen($seriesCode) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($seriesCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($seriesCode) && mb_strlen($seriesCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($seriesCode)), __LINE__);
        }
        $this->SeriesCode = $seriesCode;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Voucher
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\Voucher
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\Voucher
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Voucher
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
