<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Multimedia information for the video item. | Details for a video of a given category.
 * @subpackage Structs
 */
class VideoItemType extends AbstractStructBase
{
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: URL of the multimedia item for a specific format.
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The UnitOfMeasureCode
     * Meta information extracted from the WSDL
     * - documentation: The unit of measure associated with all the dimensions of the multimedia item. Refer to OpenTravel Code list Unit of Measure (UOM). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP,
     * or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - documentation: The width of the video item (unit specified by unit of measure).
     * - use: optional
     * @var int
     */
    public $Width;
    /**
     * The Height
     * Meta information extracted from the WSDL
     * - documentation: The height of the video item (unit specified by unit of measure).
     * - use: optional
     * @var int
     */
    public $Height;
    /**
     * The BitRate
     * Meta information extracted from the WSDL
     * - documentation: The bit rate of the video item.
     * - use: optional
     * @var int
     */
    public $BitRate;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - documentation: The length of the video item (unit specified by unit of measure).
     * - use: optional
     * @var int
     */
    public $Length;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Identifies the language of the multimedia item.
     * - type: xs:language
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - documentation: The code associated with the format of the multimedia item. Refer to OpenTravel Code list Content Format Code (CFC) | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: optional
     * @var string
     */
    public $Format;
    /**
     * The FileSize
     * Meta information extracted from the WSDL
     * - documentation: The size of the multimedia file in bytes.
     * - type: xs:positiveInteger
     * - use: optional
     * @var int
     */
    public $FileSize;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - documentation: The name of the multimedia file. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - type: StringLength1to64
     * - use: optional
     * @var string
     */
    public $FileName;
    /**
     * Constructor method for VideoItemType
     * @uses VideoItemType::setURL()
     * @uses VideoItemType::setUnitOfMeasureCode()
     * @uses VideoItemType::setWidth()
     * @uses VideoItemType::setHeight()
     * @uses VideoItemType::setBitRate()
     * @uses VideoItemType::setLength()
     * @uses VideoItemType::setLanguage()
     * @uses VideoItemType::setFormat()
     * @uses VideoItemType::setFileSize()
     * @uses VideoItemType::setFileName()
     * @param string $uRL
     * @param string $unitOfMeasureCode
     * @param int $width
     * @param int $height
     * @param int $bitRate
     * @param int $length
     * @param string $language
     * @param string $format
     * @param int $fileSize
     * @param string $fileName
     */
    public function __construct($uRL = null, $unitOfMeasureCode = null, $width = null, $height = null, $bitRate = null, $length = null, $language = null, $format = null, $fileSize = null, $fileName = null)
    {
        $this
            ->setURL($uRL)
            ->setUnitOfMeasureCode($unitOfMeasureCode)
            ->setWidth($width)
            ->setHeight($height)
            ->setBitRate($bitRate)
            ->setLength($length)
            ->setLanguage($language)
            ->setFormat($format)
            ->setFileSize($fileSize)
            ->setFileName($fileName);
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\VideoItemType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \StructType\VideoItemType
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureCode) && !is_string($unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitOfMeasureCode, true), gettype($unitOfMeasureCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($unitOfMeasureCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $unitOfMeasureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($unitOfMeasureCode, true)), __LINE__);
        }
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \StructType\VideoItemType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: int
        if (!is_null($width) && !(is_int($width) || ctype_digit($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \StructType\VideoItemType
     */
    public function setHeight($height = null)
    {
        // validation for constraint: int
        if (!is_null($height) && !(is_int($height) || ctype_digit($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->Height = $height;
        return $this;
    }
    /**
     * Get BitRate value
     * @return int|null
     */
    public function getBitRate()
    {
        return $this->BitRate;
    }
    /**
     * Set BitRate value
     * @param int $bitRate
     * @return \StructType\VideoItemType
     */
    public function setBitRate($bitRate = null)
    {
        // validation for constraint: int
        if (!is_null($bitRate) && !(is_int($bitRate) || ctype_digit($bitRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bitRate, true), gettype($bitRate)), __LINE__);
        }
        $this->BitRate = $bitRate;
        return $this;
    }
    /**
     * Get Length value
     * @return int|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param int $length
     * @return \StructType\VideoItemType
     */
    public function setLength($length = null)
    {
        // validation for constraint: int
        if (!is_null($length) && !(is_int($length) || ctype_digit($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\VideoItemType
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @param string $format
     * @return \StructType\VideoItemType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: string
        if (!is_null($format) && !is_string($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($format, true), gettype($format)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($format) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($format, true)), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
    /**
     * Get FileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->FileSize;
    }
    /**
     * Set FileSize value
     * @param int $fileSize
     * @return \StructType\VideoItemType
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !(is_int($fileSize) || ctype_digit($fileSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fileSize, true), gettype($fileSize)), __LINE__);
        }
        $this->FileSize = $fileSize;
        return $this;
    }
    /**
     * Get FileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->FileName;
    }
    /**
     * Set FileName value
     * @param string $fileName
     * @return \StructType\VideoItemType
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($fileName) && mb_strlen($fileName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($fileName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($fileName) && mb_strlen($fileName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($fileName)), __LINE__);
        }
        $this->FileName = $fileName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VideoItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
