<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VideoDescriptionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes a video item.
 * @subpackage Structs
 */
class VideoDescriptionType extends AbstractStructBase
{
    /**
     * The VideoFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VideoFormat[]
     */
    public $VideoFormat;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - documentation: Specifies the video category. Refer to OpenTravel Code list Picture Category Code (PIC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $Category;
    /**
     * Constructor method for VideoDescriptionType
     * @uses VideoDescriptionType::setVideoFormat()
     * @uses VideoDescriptionType::setCategory()
     * @param \StructType\VideoFormat[] $videoFormat
     * @param string $category
     */
    public function __construct(array $videoFormat = array(), $category = null)
    {
        $this
            ->setVideoFormat($videoFormat)
            ->setCategory($category);
    }
    /**
     * Get VideoFormat value
     * @return \StructType\VideoFormat[]|null
     */
    public function getVideoFormat()
    {
        return $this->VideoFormat;
    }
    /**
     * This method is responsible for validating the values passed to the setVideoFormat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVideoFormat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVideoFormatForArrayConstraintsFromSetVideoFormat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $videoDescriptionTypeVideoFormatItem) {
            // validation for constraint: itemType
            if (!$videoDescriptionTypeVideoFormatItem instanceof \StructType\VideoFormat) {
                $invalidValues[] = is_object($videoDescriptionTypeVideoFormatItem) ? get_class($videoDescriptionTypeVideoFormatItem) : sprintf('%s(%s)', gettype($videoDescriptionTypeVideoFormatItem), var_export($videoDescriptionTypeVideoFormatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VideoFormat property can only contain items of type \StructType\VideoFormat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VideoFormat value
     * @throws \InvalidArgumentException
     * @param \StructType\VideoFormat[] $videoFormat
     * @return \StructType\VideoDescriptionType
     */
    public function setVideoFormat(array $videoFormat = array())
    {
        // validation for constraint: array
        if ('' !== ($videoFormatArrayErrorMessage = self::validateVideoFormatForArrayConstraintsFromSetVideoFormat($videoFormat))) {
            throw new \InvalidArgumentException($videoFormatArrayErrorMessage, __LINE__);
        }
        $this->VideoFormat = $videoFormat;
        return $this;
    }
    /**
     * Add item to VideoFormat value
     * @throws \InvalidArgumentException
     * @param \StructType\VideoFormat $item
     * @return \StructType\VideoDescriptionType
     */
    public function addToVideoFormat(\StructType\VideoFormat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VideoFormat) {
            throw new \InvalidArgumentException(sprintf('The VideoFormat property can only contain items of type \StructType\VideoFormat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VideoFormat[] = $item;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\VideoDescriptionType
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($category) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($category, true)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VideoDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
