<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorMessagesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of vendor messages.
 * @subpackage Structs
 */
class VendorMessagesType extends AbstractStructBase
{
    /**
     * The VendorMessage
     * Meta information extracted from the WSDL
     * - documentation: A specific message associated with this vendor.
     * - maxOccurs: 99
     * @var \StructType\VendorMessageType[]
     */
    public $VendorMessage;
    /**
     * Constructor method for VendorMessagesType
     * @uses VendorMessagesType::setVendorMessage()
     * @param \StructType\VendorMessageType[] $vendorMessage
     */
    public function __construct(array $vendorMessage = array())
    {
        $this
            ->setVendorMessage($vendorMessage);
    }
    /**
     * Get VendorMessage value
     * @return \StructType\VendorMessageType[]|null
     */
    public function getVendorMessage()
    {
        return $this->VendorMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorMessageForArrayConstraintsFromSetVendorMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vendorMessagesTypeVendorMessageItem) {
            // validation for constraint: itemType
            if (!$vendorMessagesTypeVendorMessageItem instanceof \StructType\VendorMessageType) {
                $invalidValues[] = is_object($vendorMessagesTypeVendorMessageItem) ? get_class($vendorMessagesTypeVendorMessageItem) : sprintf('%s(%s)', gettype($vendorMessagesTypeVendorMessageItem), var_export($vendorMessagesTypeVendorMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorMessage property can only contain items of type \StructType\VendorMessageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorMessageType[] $vendorMessage
     * @return \StructType\VendorMessagesType
     */
    public function setVendorMessage(array $vendorMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorMessageArrayErrorMessage = self::validateVendorMessageForArrayConstraintsFromSetVendorMessage($vendorMessage))) {
            throw new \InvalidArgumentException($vendorMessageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($vendorMessage) && count($vendorMessage) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($vendorMessage)), __LINE__);
        }
        $this->VendorMessage = $vendorMessage;
        return $this;
    }
    /**
     * Add item to VendorMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorMessageType $item
     * @return \StructType\VendorMessagesType
     */
    public function addToVendorMessage(\StructType\VendorMessageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorMessageType) {
            throw new \InvalidArgumentException(sprintf('The VendorMessage property can only contain items of type \StructType\VendorMessageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->VendorMessage) && count($this->VendorMessage) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->VendorMessage)), __LINE__);
        }
        $this->VendorMessage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VendorMessagesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
