<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vendor StructType
 * Meta information extracted from the WSDL
 * - documentation: The vendor for this vehicle type and its participation level in a system.
 * @subpackage Structs
 */
class Vendor extends CompanyNameType
{
    /**
     * The _
     * @var \StructType\CompanyNameType
     */
    public $_;
    /**
     * The ParticipationLevelCode
     * Meta information extracted from the WSDL
     * - documentation: The participation level of this vendor in a system. Refer to OpenTravel Code List Participation Level (PLC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $ParticipationLevelCode;
    /**
     * Constructor method for Vendor
     * @uses Vendor::set_()
     * @uses Vendor::setParticipationLevelCode()
     * @param \StructType\CompanyNameType $_
     * @param string $participationLevelCode
     */
    public function __construct(\StructType\CompanyNameType $_ = null, $participationLevelCode = null)
    {
        $this
            ->set_($_)
            ->setParticipationLevelCode($participationLevelCode);
    }
    /**
     * Get _ value
     * @return \StructType\CompanyNameType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\CompanyNameType $_
     * @return \StructType\Vendor
     */
    public function set_(\StructType\CompanyNameType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get ParticipationLevelCode value
     * @return string|null
     */
    public function getParticipationLevelCode()
    {
        return $this->ParticipationLevelCode;
    }
    /**
     * Set ParticipationLevelCode value
     * @param string $participationLevelCode
     * @return \StructType\Vendor
     */
    public function setParticipationLevelCode($participationLevelCode = null)
    {
        // validation for constraint: string
        if (!is_null($participationLevelCode) && !is_string($participationLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($participationLevelCode, true), gettype($participationLevelCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($participationLevelCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $participationLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($participationLevelCode, true)), __LINE__);
        }
        $this->ParticipationLevelCode = $participationLevelCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vendor
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
