<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehiclePrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Code used to identify the vehicle. May be used in place of VehicleCoreType. Typically a SIPP code would be passed here. CodeContext Identifies the source authority for the code (e.g., SIPP). | The VehiclePrefType complex type defines
 * the information that is used when defining a preference of a vehicle.
 * @subpackage Structs
 */
class VehiclePrefType extends VehicleCoreType
{
    /**
     * The VehMakeModel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VehMakeModel
     */
    public $VehMakeModel;
    /**
     * The TypePref
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TypePref;
    /**
     * The ClassPref
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ClassPref;
    /**
     * The AirConditionPref
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AirConditionPref;
    /**
     * The TransmissionPref
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TransmissionPref;
    /**
     * The VendorCarType
     * Meta information extracted from the WSDL
     * - documentation: An internal car type assigned by the vendor. This is not the SIPP code. | Used for Alpha-Numeric Strings, length 1 to 8.
     * - base: xs:string
     * - pattern: [0-9a-zA-Z]{1,8}
     * - use: optional
     * @var string
     */
    public $VendorCarType;
    /**
     * The VehicleQty
     * Meta information extracted from the WSDL
     * - documentation: The total number of cars a customer is eventually interested in reserving. This is not used by suppliers and is in no way intended to imply that multiple cars may be booked in a single reservation.
     * - use: optional
     * @var int
     */
    public $VehicleQty;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * @var string
     */
    public $CodeContext;
    /**
     * Constructor method for VehiclePrefType
     * @uses VehiclePrefType::setVehMakeModel()
     * @uses VehiclePrefType::setTypePref()
     * @uses VehiclePrefType::setClassPref()
     * @uses VehiclePrefType::setAirConditionPref()
     * @uses VehiclePrefType::setTransmissionPref()
     * @uses VehiclePrefType::setVendorCarType()
     * @uses VehiclePrefType::setVehicleQty()
     * @uses VehiclePrefType::setCode()
     * @uses VehiclePrefType::setCodeContext()
     * @param \StructType\VehMakeModel $vehMakeModel
     * @param string $typePref
     * @param string $classPref
     * @param string $airConditionPref
     * @param string $transmissionPref
     * @param string $vendorCarType
     * @param int $vehicleQty
     * @param string $code
     * @param string $codeContext
     */
    public function __construct(\StructType\VehMakeModel $vehMakeModel = null, $typePref = null, $classPref = null, $airConditionPref = null, $transmissionPref = null, $vendorCarType = null, $vehicleQty = null, $code = null, $codeContext = null)
    {
        $this
            ->setVehMakeModel($vehMakeModel)
            ->setTypePref($typePref)
            ->setClassPref($classPref)
            ->setAirConditionPref($airConditionPref)
            ->setTransmissionPref($transmissionPref)
            ->setVendorCarType($vendorCarType)
            ->setVehicleQty($vehicleQty)
            ->setCode($code)
            ->setCodeContext($codeContext);
    }
    /**
     * Get VehMakeModel value
     * @return \StructType\VehMakeModel|null
     */
    public function getVehMakeModel()
    {
        return $this->VehMakeModel;
    }
    /**
     * Set VehMakeModel value
     * @param \StructType\VehMakeModel $vehMakeModel
     * @return \StructType\VehiclePrefType
     */
    public function setVehMakeModel(\StructType\VehMakeModel $vehMakeModel = null)
    {
        $this->VehMakeModel = $vehMakeModel;
        return $this;
    }
    /**
     * Get TypePref value
     * @return string|null
     */
    public function getTypePref()
    {
        return $this->TypePref;
    }
    /**
     * Set TypePref value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typePref
     * @return \StructType\VehiclePrefType
     */
    public function setTypePref($typePref = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($typePref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($typePref) ? implode(', ', $typePref) : var_export($typePref, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->TypePref = $typePref;
        return $this;
    }
    /**
     * Get ClassPref value
     * @return string|null
     */
    public function getClassPref()
    {
        return $this->ClassPref;
    }
    /**
     * Set ClassPref value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $classPref
     * @return \StructType\VehiclePrefType
     */
    public function setClassPref($classPref = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($classPref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($classPref) ? implode(', ', $classPref) : var_export($classPref, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->ClassPref = $classPref;
        return $this;
    }
    /**
     * Get AirConditionPref value
     * @return string|null
     */
    public function getAirConditionPref()
    {
        return $this->AirConditionPref;
    }
    /**
     * Set AirConditionPref value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airConditionPref
     * @return \StructType\VehiclePrefType
     */
    public function setAirConditionPref($airConditionPref = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($airConditionPref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($airConditionPref) ? implode(', ', $airConditionPref) : var_export($airConditionPref, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->AirConditionPref = $airConditionPref;
        return $this;
    }
    /**
     * Get TransmissionPref value
     * @return string|null
     */
    public function getTransmissionPref()
    {
        return $this->TransmissionPref;
    }
    /**
     * Set TransmissionPref value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transmissionPref
     * @return \StructType\VehiclePrefType
     */
    public function setTransmissionPref($transmissionPref = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($transmissionPref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($transmissionPref) ? implode(', ', $transmissionPref) : var_export($transmissionPref, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->TransmissionPref = $transmissionPref;
        return $this;
    }
    /**
     * Get VendorCarType value
     * @return string|null
     */
    public function getVendorCarType()
    {
        return $this->VendorCarType;
    }
    /**
     * Set VendorCarType value
     * @param string $vendorCarType
     * @return \StructType\VehiclePrefType
     */
    public function setVendorCarType($vendorCarType = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCarType) && !is_string($vendorCarType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCarType, true), gettype($vendorCarType)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-zA-Z]{1,8})
        if (!is_null($vendorCarType) && !preg_match('/[0-9a-zA-Z]{1,8}/', $vendorCarType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-zA-Z]{1,8}', var_export($vendorCarType, true)), __LINE__);
        }
        $this->VendorCarType = $vendorCarType;
        return $this;
    }
    /**
     * Get VehicleQty value
     * @return int|null
     */
    public function getVehicleQty()
    {
        return $this->VehicleQty;
    }
    /**
     * Set VehicleQty value
     * @param int $vehicleQty
     * @return \StructType\VehiclePrefType
     */
    public function setVehicleQty($vehicleQty = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleQty) && !(is_int($vehicleQty) || ctype_digit($vehicleQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleQty, true), gettype($vehicleQty)), __LINE__);
        }
        $this->VehicleQty = $vehicleQty;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\VehiclePrefType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($code) && mb_strlen($code) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\VehiclePrefType
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($codeContext) && mb_strlen($codeContext) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($codeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeContext) && mb_strlen($codeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehiclePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
