<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleLocationDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleLocationDetailsType complex type defines the core information that describes a vehicle rental facility. Such information may include the code of the facility, the name assigned to that facility, the address and telephone
 * number of the facility.
 * @subpackage Structs
 */
class VehicleLocationDetailsType extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Information about the physical address of the location
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\AddressInfoType[]
     */
    public $Address;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * The AdditionalInfo
     * Meta information extracted from the WSDL
     * - documentation: Supplemental information about the rental facility.
     * - minOccurs: 0
     * @var \StructType\VehicleLocationAdditionalDetailsType
     */
    public $AdditionalInfo;
    /**
     * The AtAirport
     * Meta information extracted from the WSDL
     * - documentation: The AtAirport attribute identifies if the associated rental location serves an airport.
     * - use: optional
     * @var bool
     */
    public $AtAirport;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Code used to identify the car rental location. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name used to refer to the car rental location. | Used for Character Strings, length 1 to 64.
     * - base: xs:string
     * - maxLength: 64
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The CodeContext
     * Meta information extracted from the WSDL
     * - documentation: Used to define which list the location code comes from (e.g. IATA, OAG, internal company code). | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $CodeContext;
    /**
     * The ExtendedLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Used for extended OAG code in conjunction with the OAG code which is sent in Code. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $ExtendedLocationCode;
    /**
     * The AssocAirportLocList
     * Meta information extracted from the WSDL
     * - documentation: Additional airport location codes associated with the primary airport. | Used for Character Strings, length 1 to 8. | List of StringLength1to8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - use: optional
     * @var string[]
     */
    public $AssocAirportLocList;
    /**
     * Constructor method for VehicleLocationDetailsType
     * @uses VehicleLocationDetailsType::setAddress()
     * @uses VehicleLocationDetailsType::setTelephone()
     * @uses VehicleLocationDetailsType::setAdditionalInfo()
     * @uses VehicleLocationDetailsType::setAtAirport()
     * @uses VehicleLocationDetailsType::setCode()
     * @uses VehicleLocationDetailsType::setName()
     * @uses VehicleLocationDetailsType::setCodeContext()
     * @uses VehicleLocationDetailsType::setExtendedLocationCode()
     * @uses VehicleLocationDetailsType::setAssocAirportLocList()
     * @param \StructType\AddressInfoType[] $address
     * @param \StructType\Telephone[] $telephone
     * @param \StructType\VehicleLocationAdditionalDetailsType $additionalInfo
     * @param bool $atAirport
     * @param string $code
     * @param string $name
     * @param string $codeContext
     * @param string $extendedLocationCode
     * @param string[] $assocAirportLocList
     */
    public function __construct(array $address = array(), array $telephone = array(), \StructType\VehicleLocationAdditionalDetailsType $additionalInfo = null, $atAirport = null, $code = null, $name = null, $codeContext = null, $extendedLocationCode = null, array $assocAirportLocList = array())
    {
        $this
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setAdditionalInfo($additionalInfo)
            ->setAtAirport($atAirport)
            ->setCode($code)
            ->setName($name)
            ->setCodeContext($codeContext)
            ->setExtendedLocationCode($extendedLocationCode)
            ->setAssocAirportLocList($assocAirportLocList);
    }
    /**
     * Get Address value
     * @return \StructType\AddressInfoType[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * This method is responsible for validating the values passed to the setAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressForArrayConstraintsFromSetAddress(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleLocationDetailsTypeAddressItem) {
            // validation for constraint: itemType
            if (!$vehicleLocationDetailsTypeAddressItem instanceof \StructType\AddressInfoType) {
                $invalidValues[] = is_object($vehicleLocationDetailsTypeAddressItem) ? get_class($vehicleLocationDetailsTypeAddressItem) : sprintf('%s(%s)', gettype($vehicleLocationDetailsTypeAddressItem), var_export($vehicleLocationDetailsTypeAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Address property can only contain items of type \StructType\AddressInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressInfoType[] $address
     * @return \StructType\VehicleLocationDetailsType
     */
    public function setAddress(array $address = array())
    {
        // validation for constraint: array
        if ('' !== ($addressArrayErrorMessage = self::validateAddressForArrayConstraintsFromSetAddress($address))) {
            throw new \InvalidArgumentException($addressArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($address) && count($address) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressInfoType $item
     * @return \StructType\VehicleLocationDetailsType
     */
    public function addToAddress(\StructType\AddressInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressInfoType) {
            throw new \InvalidArgumentException(sprintf('The Address property can only contain items of type \StructType\AddressInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Address) && count($this->Address) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Address)), __LINE__);
        }
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleLocationDetailsTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$vehicleLocationDetailsTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($vehicleLocationDetailsTypeTelephoneItem) ? get_class($vehicleLocationDetailsTypeTelephoneItem) : sprintf('%s(%s)', gettype($vehicleLocationDetailsTypeTelephoneItem), var_export($vehicleLocationDetailsTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\VehicleLocationDetailsType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($telephone) && count($telephone) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\VehicleLocationDetailsType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Telephone) && count($this->Telephone) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Telephone)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return \StructType\VehicleLocationAdditionalDetailsType|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param \StructType\VehicleLocationAdditionalDetailsType $additionalInfo
     * @return \StructType\VehicleLocationDetailsType
     */
    public function setAdditionalInfo(\StructType\VehicleLocationAdditionalDetailsType $additionalInfo = null)
    {
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get AtAirport value
     * @return bool|null
     */
    public function getAtAirport()
    {
        return $this->AtAirport;
    }
    /**
     * Set AtAirport value
     * @param bool $atAirport
     * @return \StructType\VehicleLocationDetailsType
     */
    public function setAtAirport($atAirport = null)
    {
        // validation for constraint: boolean
        if (!is_null($atAirport) && !is_bool($atAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($atAirport, true), gettype($atAirport)), __LINE__);
        }
        $this->AtAirport = $atAirport;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\VehicleLocationDetailsType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($code) && mb_strlen($code) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\VehicleLocationDetailsType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($name) && mb_strlen($name) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \StructType\VehicleLocationDetailsType
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeContext, true), gettype($codeContext)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($codeContext) && mb_strlen($codeContext) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($codeContext)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($codeContext) && mb_strlen($codeContext) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get ExtendedLocationCode value
     * @return string|null
     */
    public function getExtendedLocationCode()
    {
        return $this->ExtendedLocationCode;
    }
    /**
     * Set ExtendedLocationCode value
     * @param string $extendedLocationCode
     * @return \StructType\VehicleLocationDetailsType
     */
    public function setExtendedLocationCode($extendedLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($extendedLocationCode) && !is_string($extendedLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extendedLocationCode, true), gettype($extendedLocationCode)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($extendedLocationCode) && mb_strlen($extendedLocationCode) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($extendedLocationCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($extendedLocationCode) && mb_strlen($extendedLocationCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($extendedLocationCode)), __LINE__);
        }
        $this->ExtendedLocationCode = $extendedLocationCode;
        return $this;
    }
    /**
     * Get AssocAirportLocList value
     * @return string[]|null
     */
    public function getAssocAirportLocList()
    {
        return $this->AssocAirportLocList;
    }
    /**
     * This method is responsible for validating the values passed to the setAssocAirportLocList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssocAirportLocList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssocAirportLocListForArrayConstraintsFromSetAssocAirportLocList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleLocationDetailsTypeAssocAirportLocListItem) {
            // validation for constraint: itemType
            if (!is_string($vehicleLocationDetailsTypeAssocAirportLocListItem)) {
                $invalidValues[] = is_object($vehicleLocationDetailsTypeAssocAirportLocListItem) ? get_class($vehicleLocationDetailsTypeAssocAirportLocListItem) : sprintf('%s(%s)', gettype($vehicleLocationDetailsTypeAssocAirportLocListItem), var_export($vehicleLocationDetailsTypeAssocAirportLocListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AssocAirportLocList property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssocAirportLocList value
     * @param string[] $assocAirportLocList
     * @return \StructType\VehicleLocationDetailsType
     */
    public function setAssocAirportLocList(array $assocAirportLocList = array())
    {
        // validation for constraint: list
        if ('' !== ($assocAirportLocListArrayErrorMessage = self::validateAssocAirportLocListForArrayConstraintsFromSetAssocAirportLocList($assocAirportLocList))) {
            throw new \InvalidArgumentException($assocAirportLocListArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($assocAirportLocList) && mb_strlen($assocAirportLocList) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($assocAirportLocList)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($assocAirportLocList) && mb_strlen($assocAirportLocList) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($assocAirportLocList)), __LINE__);
        }
        $this->AssocAirportLocList = is_array($assocAirportLocList) ? implode(' ', $assocAirportLocList) : null;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleLocationDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
