<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleInfos StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of descriptions about various aspects of the vehicles.
 * @subpackage Structs
 */
class VehicleInfos extends AbstractStructBase
{
    /**
     * The VehicleInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\VehicleInfo[]
     */
    public $VehicleInfo;
    /**
     * Constructor method for VehicleInfos
     * @uses VehicleInfos::setVehicleInfo()
     * @param \StructType\VehicleInfo[] $vehicleInfo
     */
    public function __construct(array $vehicleInfo = array())
    {
        $this
            ->setVehicleInfo($vehicleInfo);
    }
    /**
     * Get VehicleInfo value
     * @return \StructType\VehicleInfo[]|null
     */
    public function getVehicleInfo()
    {
        return $this->VehicleInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setVehicleInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehicleInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehicleInfoForArrayConstraintsFromSetVehicleInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleInfosVehicleInfoItem) {
            // validation for constraint: itemType
            if (!$vehicleInfosVehicleInfoItem instanceof \StructType\VehicleInfo) {
                $invalidValues[] = is_object($vehicleInfosVehicleInfoItem) ? get_class($vehicleInfosVehicleInfoItem) : sprintf('%s(%s)', gettype($vehicleInfosVehicleInfoItem), var_export($vehicleInfosVehicleInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehicleInfo property can only contain items of type \StructType\VehicleInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehicleInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleInfo[] $vehicleInfo
     * @return \StructType\VehicleInfos
     */
    public function setVehicleInfo(array $vehicleInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($vehicleInfoArrayErrorMessage = self::validateVehicleInfoForArrayConstraintsFromSetVehicleInfo($vehicleInfo))) {
            throw new \InvalidArgumentException($vehicleInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($vehicleInfo) && count($vehicleInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($vehicleInfo)), __LINE__);
        }
        $this->VehicleInfo = $vehicleInfo;
        return $this;
    }
    /**
     * Add item to VehicleInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleInfo $item
     * @return \StructType\VehicleInfos
     */
    public function addToVehicleInfo(\StructType\VehicleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleInfo) {
            throw new \InvalidArgumentException(sprintf('The VehicleInfo property can only contain items of type \StructType\VehicleInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->VehicleInfo) && count($this->VehicleInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->VehicleInfo)), __LINE__);
        }
        $this->VehicleInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
