<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleEquipmentPricedType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleEquipmentPricedType complex type identifies the data that describes a priced piece of special equipment in association with the rental of a vehicle. The data consists of the equipment and the correspondinng charge.
 * @subpackage Structs
 */
class VehicleEquipmentPricedType extends AbstractStructBase
{
    /**
     * The Equipment
     * Meta information extracted from the WSDL
     * - documentation: Details about a equipment, such as text or description.
     * @var \StructType\VehicleEquipmentType
     */
    public $Equipment;
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - documentation: The charges as they relate to a single piece of equipment, such as minimum or maximum amounts, taxes, or information on how the charge was calculated.
     * @var \StructType\VehicleChargeType
     */
    public $Charge;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: false | An indication if this particular equipment is required in the vehicle reservation, or is optional, based upon renter preference.
     * - use: optional
     * @var bool
     */
    public $Required;
    /**
     * Constructor method for VehicleEquipmentPricedType
     * @uses VehicleEquipmentPricedType::setEquipment()
     * @uses VehicleEquipmentPricedType::setCharge()
     * @uses VehicleEquipmentPricedType::setRequired()
     * @param \StructType\VehicleEquipmentType $equipment
     * @param \StructType\VehicleChargeType $charge
     * @param bool $required
     */
    public function __construct(\StructType\VehicleEquipmentType $equipment = null, \StructType\VehicleChargeType $charge = null, $required = null)
    {
        $this
            ->setEquipment($equipment)
            ->setCharge($charge)
            ->setRequired($required);
    }
    /**
     * Get Equipment value
     * @return \StructType\VehicleEquipmentType|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \StructType\VehicleEquipmentType $equipment
     * @return \StructType\VehicleEquipmentPricedType
     */
    public function setEquipment(\StructType\VehicleEquipmentType $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get Charge value
     * @return \StructType\VehicleChargeType|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * Set Charge value
     * @param \StructType\VehicleChargeType $charge
     * @return \StructType\VehicleEquipmentPricedType
     */
    public function setCharge(\StructType\VehicleChargeType $charge = null)
    {
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Get Required value
     * @return bool|null
     */
    public function getRequired()
    {
        return $this->Required;
    }
    /**
     * Set Required value
     * @param bool $required
     * @return \StructType\VehicleEquipmentPricedType
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        $this->Required = $required;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleEquipmentPricedType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
