<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleAvailRQAdditionalInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The VehicleAvailRQAdditionalInfoType complex type identifies supplemental information that may be included in a request for vehicle availability and rates.
 * @subpackage Structs
 */
class VehicleAvailRQAdditionalInfoType extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - documentation: Information on the one primary driver and, optionally, several additional drivers. This may be used to provide a frequent renter number.
     * - minOccurs: 0
     * @var \StructType\CustomerPrimaryAdditionalType
     */
    public $Customer;
    /**
     * The SpecialReqPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates the preference associated with special needs or requirements of the customer, described using free text
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\VehicleSpecialReqPrefType[]
     */
    public $SpecialReqPref;
    /**
     * The CoveragePrefs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CoveragePrefs
     */
    public $CoveragePrefs;
    /**
     * The OffLocService
     * Meta information extracted from the WSDL
     * - documentation: Information on requested off-airport location services, for example, vehicle delivery, customer pickup.
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \StructType\OffLocationServiceType[]
     */
    public $OffLocService;
    /**
     * The ArrivalDetails
     * Meta information extracted from the WSDL
     * - documentation: Details of the arrival transportation, if applicable
     * - minOccurs: 0
     * @var \StructType\VehicleArrivalDetailsType
     */
    public $ArrivalDetails;
    /**
     * The TourInfo
     * Meta information extracted from the WSDL
     * - documentation: Details of a tour with which this availability information is associated. Availability and rate information may vary if associated with a tour.
     * - minOccurs: 0
     * @var \StructType\VehicleTourInfoType
     */
    public $TourInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var \StructType\TPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The LuggageQty
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $LuggageQty;
    /**
     * The PassengerQty
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $PassengerQty;
    /**
     * The GasPrePay
     * Meta information extracted from the WSDL
     * - documentation: false | The GasPrePay attribute defines a set of valid values for the choice of prepaying for gas at the time of the pick up of the rental vehicle. This information is useful in that it allows a customer's preference to be made known
     * to the vendor. It also allows the vendor to provide more detailed and accurate pricing up front.
     * - use: optional
     * @var bool
     */
    public $GasPrePay;
    /**
     * The SingleQuote
     * Meta information extracted from the WSDL
     * - documentation: Allows the requestor to indicate if the response should contain a single rate for each product or multiple rates for each product. Multiple rates may be offered when different terms and conditions may apply, for example pre-paid
     * versus payment at time of rental. The use of multiple rates may vary from vendor to vendor and is by agreement of the trading partners.
     * - use: optional
     * @var bool
     */
    public $SingleQuote;
    /**
     * The SmokingAllowed
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * Constructor method for VehicleAvailRQAdditionalInfoType
     * @uses VehicleAvailRQAdditionalInfoType::setCustomer()
     * @uses VehicleAvailRQAdditionalInfoType::setSpecialReqPref()
     * @uses VehicleAvailRQAdditionalInfoType::setCoveragePrefs()
     * @uses VehicleAvailRQAdditionalInfoType::setOffLocService()
     * @uses VehicleAvailRQAdditionalInfoType::setArrivalDetails()
     * @uses VehicleAvailRQAdditionalInfoType::setTourInfo()
     * @uses VehicleAvailRQAdditionalInfoType::setTPA_Extensions()
     * @uses VehicleAvailRQAdditionalInfoType::setLuggageQty()
     * @uses VehicleAvailRQAdditionalInfoType::setPassengerQty()
     * @uses VehicleAvailRQAdditionalInfoType::setGasPrePay()
     * @uses VehicleAvailRQAdditionalInfoType::setSingleQuote()
     * @uses VehicleAvailRQAdditionalInfoType::setSmokingAllowed()
     * @param \StructType\CustomerPrimaryAdditionalType $customer
     * @param \StructType\VehicleSpecialReqPrefType[] $specialReqPref
     * @param \StructType\CoveragePrefs $coveragePrefs
     * @param \StructType\OffLocationServiceType[] $offLocService
     * @param \StructType\VehicleArrivalDetailsType $arrivalDetails
     * @param \StructType\VehicleTourInfoType $tourInfo
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @param int $luggageQty
     * @param int $passengerQty
     * @param bool $gasPrePay
     * @param bool $singleQuote
     * @param bool $smokingAllowed
     */
    public function __construct(\StructType\CustomerPrimaryAdditionalType $customer = null, array $specialReqPref = array(), \StructType\CoveragePrefs $coveragePrefs = null, array $offLocService = array(), \StructType\VehicleArrivalDetailsType $arrivalDetails = null, \StructType\VehicleTourInfoType $tourInfo = null, \StructType\TPA_ExtensionsType $tPA_Extensions = null, $luggageQty = null, $passengerQty = null, $gasPrePay = null, $singleQuote = null, $smokingAllowed = null)
    {
        $this
            ->setCustomer($customer)
            ->setSpecialReqPref($specialReqPref)
            ->setCoveragePrefs($coveragePrefs)
            ->setOffLocService($offLocService)
            ->setArrivalDetails($arrivalDetails)
            ->setTourInfo($tourInfo)
            ->setTPA_Extensions($tPA_Extensions)
            ->setLuggageQty($luggageQty)
            ->setPassengerQty($passengerQty)
            ->setGasPrePay($gasPrePay)
            ->setSingleQuote($singleQuote)
            ->setSmokingAllowed($smokingAllowed);
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerPrimaryAdditionalType|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerPrimaryAdditionalType $customer
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setCustomer(\StructType\CustomerPrimaryAdditionalType $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get SpecialReqPref value
     * @return \StructType\VehicleSpecialReqPrefType[]|null
     */
    public function getSpecialReqPref()
    {
        return $this->SpecialReqPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialReqPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialReqPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialReqPrefForArrayConstraintsFromSetSpecialReqPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem instanceof \StructType\VehicleSpecialReqPrefType) {
                $invalidValues[] = is_object($vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem) ? get_class($vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem) : sprintf('%s(%s)', gettype($vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem), var_export($vehicleAvailRQAdditionalInfoTypeSpecialReqPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialReqPref property can only contain items of type \StructType\VehicleSpecialReqPrefType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleSpecialReqPrefType[] $specialReqPref
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setSpecialReqPref(array $specialReqPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specialReqPrefArrayErrorMessage = self::validateSpecialReqPrefForArrayConstraintsFromSetSpecialReqPref($specialReqPref))) {
            throw new \InvalidArgumentException($specialReqPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($specialReqPref) && count($specialReqPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($specialReqPref)), __LINE__);
        }
        $this->SpecialReqPref = $specialReqPref;
        return $this;
    }
    /**
     * Add item to SpecialReqPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleSpecialReqPrefType $item
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function addToSpecialReqPref(\StructType\VehicleSpecialReqPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleSpecialReqPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqPref property can only contain items of type \StructType\VehicleSpecialReqPrefType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->SpecialReqPref) && count($this->SpecialReqPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->SpecialReqPref)), __LINE__);
        }
        $this->SpecialReqPref[] = $item;
        return $this;
    }
    /**
     * Get CoveragePrefs value
     * @return \StructType\CoveragePrefs|null
     */
    public function getCoveragePrefs()
    {
        return $this->CoveragePrefs;
    }
    /**
     * Set CoveragePrefs value
     * @param \StructType\CoveragePrefs $coveragePrefs
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setCoveragePrefs(\StructType\CoveragePrefs $coveragePrefs = null)
    {
        $this->CoveragePrefs = $coveragePrefs;
        return $this;
    }
    /**
     * Get OffLocService value
     * @return \StructType\OffLocationServiceType[]|null
     */
    public function getOffLocService()
    {
        return $this->OffLocService;
    }
    /**
     * This method is responsible for validating the values passed to the setOffLocService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOffLocService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOffLocServiceForArrayConstraintsFromSetOffLocService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleAvailRQAdditionalInfoTypeOffLocServiceItem) {
            // validation for constraint: itemType
            if (!$vehicleAvailRQAdditionalInfoTypeOffLocServiceItem instanceof \StructType\OffLocationServiceType) {
                $invalidValues[] = is_object($vehicleAvailRQAdditionalInfoTypeOffLocServiceItem) ? get_class($vehicleAvailRQAdditionalInfoTypeOffLocServiceItem) : sprintf('%s(%s)', gettype($vehicleAvailRQAdditionalInfoTypeOffLocServiceItem), var_export($vehicleAvailRQAdditionalInfoTypeOffLocServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OffLocService property can only contain items of type \StructType\OffLocationServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OffLocService value
     * @throws \InvalidArgumentException
     * @param \StructType\OffLocationServiceType[] $offLocService
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setOffLocService(array $offLocService = array())
    {
        // validation for constraint: array
        if ('' !== ($offLocServiceArrayErrorMessage = self::validateOffLocServiceForArrayConstraintsFromSetOffLocService($offLocService))) {
            throw new \InvalidArgumentException($offLocServiceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($offLocService) && count($offLocService) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($offLocService)), __LINE__);
        }
        $this->OffLocService = $offLocService;
        return $this;
    }
    /**
     * Add item to OffLocService value
     * @throws \InvalidArgumentException
     * @param \StructType\OffLocationServiceType $item
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function addToOffLocService(\StructType\OffLocationServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OffLocationServiceType) {
            throw new \InvalidArgumentException(sprintf('The OffLocService property can only contain items of type \StructType\OffLocationServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->OffLocService) && count($this->OffLocService) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->OffLocService)), __LINE__);
        }
        $this->OffLocService[] = $item;
        return $this;
    }
    /**
     * Get ArrivalDetails value
     * @return \StructType\VehicleArrivalDetailsType|null
     */
    public function getArrivalDetails()
    {
        return $this->ArrivalDetails;
    }
    /**
     * Set ArrivalDetails value
     * @param \StructType\VehicleArrivalDetailsType $arrivalDetails
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setArrivalDetails(\StructType\VehicleArrivalDetailsType $arrivalDetails = null)
    {
        $this->ArrivalDetails = $arrivalDetails;
        return $this;
    }
    /**
     * Get TourInfo value
     * @return \StructType\VehicleTourInfoType|null
     */
    public function getTourInfo()
    {
        return $this->TourInfo;
    }
    /**
     * Set TourInfo value
     * @param \StructType\VehicleTourInfoType $tourInfo
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setTourInfo(\StructType\VehicleTourInfoType $tourInfo = null)
    {
        $this->TourInfo = $tourInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \StructType\TPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \StructType\TPA_ExtensionsType $tPA_Extensions
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setTPA_Extensions(\StructType\TPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get LuggageQty value
     * @return int|null
     */
    public function getLuggageQty()
    {
        return $this->LuggageQty;
    }
    /**
     * Set LuggageQty value
     * @param int $luggageQty
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setLuggageQty($luggageQty = null)
    {
        // validation for constraint: int
        if (!is_null($luggageQty) && !(is_int($luggageQty) || ctype_digit($luggageQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($luggageQty, true), gettype($luggageQty)), __LINE__);
        }
        $this->LuggageQty = $luggageQty;
        return $this;
    }
    /**
     * Get PassengerQty value
     * @return int|null
     */
    public function getPassengerQty()
    {
        return $this->PassengerQty;
    }
    /**
     * Set PassengerQty value
     * @param int $passengerQty
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setPassengerQty($passengerQty = null)
    {
        // validation for constraint: int
        if (!is_null($passengerQty) && !(is_int($passengerQty) || ctype_digit($passengerQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passengerQty, true), gettype($passengerQty)), __LINE__);
        }
        $this->PassengerQty = $passengerQty;
        return $this;
    }
    /**
     * Get GasPrePay value
     * @return bool|null
     */
    public function getGasPrePay()
    {
        return $this->GasPrePay;
    }
    /**
     * Set GasPrePay value
     * @param bool $gasPrePay
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setGasPrePay($gasPrePay = null)
    {
        // validation for constraint: boolean
        if (!is_null($gasPrePay) && !is_bool($gasPrePay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($gasPrePay, true), gettype($gasPrePay)), __LINE__);
        }
        $this->GasPrePay = $gasPrePay;
        return $this;
    }
    /**
     * Get SingleQuote value
     * @return bool|null
     */
    public function getSingleQuote()
    {
        return $this->SingleQuote;
    }
    /**
     * Set SingleQuote value
     * @param bool $singleQuote
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setSingleQuote($singleQuote = null)
    {
        // validation for constraint: boolean
        if (!is_null($singleQuote) && !is_bool($singleQuote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($singleQuote, true), gettype($singleQuote)), __LINE__);
        }
        $this->SingleQuote = $singleQuote;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smokingAllowed, true), gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleAvailRQAdditionalInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
