<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Vehicle StructType
 * Meta information extracted from the WSDL
 * - documentation: Vehicle info including size, class, make/model, vehicle asset number, etc. This is the actual vehicle being rented. | Specific information about a vehicle that is offered for rental at this facility. This element may repeat to
 * identify all vehicles that may be rented from this facility. | This element may be used to clarify the vehicle associated with this charge, if the charge varies by vehicle type. | Identifies a specific vehicle type. | To identify a vehicle type
 * associated with additional driver information.
 * @subpackage Structs
 */
class Vehicle extends VehicleType
{
    /**
     * The IncludeExclude
     * Meta information extracted from the WSDL
     * - documentation: To indicate if the coverage is required, allowed, included, or excluded for this vehicle type. | To specify if this car type is allowed, required, included, excluded for the associated age. | To specify if this vehicle type is
     * allowed, required, excluded, or included for an additional driver.
     * - use: optional
     * @var string
     */
    public $IncludeExclude;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Free text information for this vehicle type.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\FormattedTextType[]
     */
    public $Text;
    /**
     * The IsConfirmableInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this car type may be confirmed. If false, it may not be confirmed.
     * - use: optional
     * @var bool
     */
    public $IsConfirmableInd;
    /**
     * The DistanceUnit
     * Meta information extracted from the WSDL
     * - documentation: To specify whether mileage information is miles or kilometers.
     * - use: optional
     * @var string
     */
    public $DistanceUnit;
    /**
     * The DistancePerFuelUnit
     * Meta information extracted from the WSDL
     * - documentation: To specify the number of miles/kilometers per gallon/litre of gas. | Used for Numeric values, from 0 to 99 inclusive.
     * - base: xs:integer
     * - maxInclusive: 99
     * - minInclusive: 0
     * - use: optional
     * @var int
     */
    public $DistancePerFuelUnit;
    /**
     * The VehRentalDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\VehicleRentalDetailsType[]
     */
    public $VehRentalDetails;
    /**
     * Constructor method for Vehicle
     * @uses Vehicle::setIncludeExclude()
     * @uses Vehicle::setText()
     * @uses Vehicle::setIsConfirmableInd()
     * @uses Vehicle::setDistanceUnit()
     * @uses Vehicle::setDistancePerFuelUnit()
     * @uses Vehicle::setVehRentalDetails()
     * @param string $includeExclude
     * @param \StructType\FormattedTextType[] $text
     * @param bool $isConfirmableInd
     * @param string $distanceUnit
     * @param int $distancePerFuelUnit
     * @param \StructType\VehicleRentalDetailsType[] $vehRentalDetails
     */
    public function __construct($includeExclude = null, array $text = array(), $isConfirmableInd = null, $distanceUnit = null, $distancePerFuelUnit = null, array $vehRentalDetails = array())
    {
        $this
            ->setIncludeExclude($includeExclude)
            ->setText($text)
            ->setIsConfirmableInd($isConfirmableInd)
            ->setDistanceUnit($distanceUnit)
            ->setDistancePerFuelUnit($distancePerFuelUnit)
            ->setVehRentalDetails($vehRentalDetails);
    }
    /**
     * Get IncludeExclude value
     * @return string|null
     */
    public function getIncludeExclude()
    {
        return $this->IncludeExclude;
    }
    /**
     * Set IncludeExclude value
     * @uses \EnumType\IncludeExcludeType::valueIsValid()
     * @uses \EnumType\IncludeExcludeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeExclude
     * @return \StructType\Vehicle
     */
    public function setIncludeExclude($includeExclude = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IncludeExcludeType::valueIsValid($includeExclude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IncludeExcludeType', is_array($includeExclude) ? implode(', ', $includeExclude) : var_export($includeExclude, true), implode(', ', \EnumType\IncludeExcludeType::getValidValues())), __LINE__);
        }
        $this->IncludeExclude = $includeExclude;
        return $this;
    }
    /**
     * Get Text value
     * @return \StructType\FormattedTextType[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * This method is responsible for validating the values passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextForArrayConstraintsFromSetText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleTextItem) {
            // validation for constraint: itemType
            if (!$vehicleTextItem instanceof \StructType\FormattedTextType) {
                $invalidValues[] = is_object($vehicleTextItem) ? get_class($vehicleTextItem) : sprintf('%s(%s)', gettype($vehicleTextItem), var_export($vehicleTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Text property can only contain items of type \StructType\FormattedTextType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param \StructType\FormattedTextType[] $text
     * @return \StructType\Vehicle
     */
    public function setText(array $text = array())
    {
        // validation for constraint: array
        if ('' !== ($textArrayErrorMessage = self::validateTextForArrayConstraintsFromSetText($text))) {
            throw new \InvalidArgumentException($textArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($text) && count($text) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param \StructType\FormattedTextType $item
     * @return \StructType\Vehicle
     */
    public function addToText(\StructType\FormattedTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FormattedTextType) {
            throw new \InvalidArgumentException(sprintf('The Text property can only contain items of type \StructType\FormattedTextType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Text) && count($this->Text) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Text)), __LINE__);
        }
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get IsConfirmableInd value
     * @return bool|null
     */
    public function getIsConfirmableInd()
    {
        return $this->IsConfirmableInd;
    }
    /**
     * Set IsConfirmableInd value
     * @param bool $isConfirmableInd
     * @return \StructType\Vehicle
     */
    public function setIsConfirmableInd($isConfirmableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirmableInd) && !is_bool($isConfirmableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirmableInd, true), gettype($isConfirmableInd)), __LINE__);
        }
        $this->IsConfirmableInd = $isConfirmableInd;
        return $this;
    }
    /**
     * Get DistanceUnit value
     * @return string|null
     */
    public function getDistanceUnit()
    {
        return $this->DistanceUnit;
    }
    /**
     * Set DistanceUnit value
     * @uses \EnumType\DistanceUnitNameType::valueIsValid()
     * @uses \EnumType\DistanceUnitNameType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distanceUnit
     * @return \StructType\Vehicle
     */
    public function setDistanceUnit($distanceUnit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistanceUnitNameType::valueIsValid($distanceUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DistanceUnitNameType', is_array($distanceUnit) ? implode(', ', $distanceUnit) : var_export($distanceUnit, true), implode(', ', \EnumType\DistanceUnitNameType::getValidValues())), __LINE__);
        }
        $this->DistanceUnit = $distanceUnit;
        return $this;
    }
    /**
     * Get DistancePerFuelUnit value
     * @return int|null
     */
    public function getDistancePerFuelUnit()
    {
        return $this->DistancePerFuelUnit;
    }
    /**
     * Set DistancePerFuelUnit value
     * @param int $distancePerFuelUnit
     * @return \StructType\Vehicle
     */
    public function setDistancePerFuelUnit($distancePerFuelUnit = null)
    {
        // validation for constraint: int
        if (!is_null($distancePerFuelUnit) && !(is_int($distancePerFuelUnit) || ctype_digit($distancePerFuelUnit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distancePerFuelUnit, true), gettype($distancePerFuelUnit)), __LINE__);
        }
        // validation for constraint: maxInclusive(99)
        if (!is_null($distancePerFuelUnit) && $distancePerFuelUnit > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99', var_export($distancePerFuelUnit, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($distancePerFuelUnit) && $distancePerFuelUnit < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($distancePerFuelUnit, true)), __LINE__);
        }
        $this->DistancePerFuelUnit = $distancePerFuelUnit;
        return $this;
    }
    /**
     * Get VehRentalDetails value
     * @return \StructType\VehicleRentalDetailsType[]|null
     */
    public function getVehRentalDetails()
    {
        return $this->VehRentalDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setVehRentalDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehRentalDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehRentalDetailsForArrayConstraintsFromSetVehRentalDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vehicleVehRentalDetailsItem) {
            // validation for constraint: itemType
            if (!$vehicleVehRentalDetailsItem instanceof \StructType\VehicleRentalDetailsType) {
                $invalidValues[] = is_object($vehicleVehRentalDetailsItem) ? get_class($vehicleVehRentalDetailsItem) : sprintf('%s(%s)', gettype($vehicleVehRentalDetailsItem), var_export($vehicleVehRentalDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehRentalDetails property can only contain items of type \StructType\VehicleRentalDetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VehRentalDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleRentalDetailsType[] $vehRentalDetails
     * @return \StructType\Vehicle
     */
    public function setVehRentalDetails(array $vehRentalDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($vehRentalDetailsArrayErrorMessage = self::validateVehRentalDetailsForArrayConstraintsFromSetVehRentalDetails($vehRentalDetails))) {
            throw new \InvalidArgumentException($vehRentalDetailsArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($vehRentalDetails) && count($vehRentalDetails) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($vehRentalDetails)), __LINE__);
        }
        $this->VehRentalDetails = $vehRentalDetails;
        return $this;
    }
    /**
     * Add item to VehRentalDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleRentalDetailsType $item
     * @return \StructType\Vehicle
     */
    public function addToVehRentalDetails(\StructType\VehicleRentalDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleRentalDetailsType) {
            throw new \InvalidArgumentException(sprintf('The VehRentalDetails property can only contain items of type \StructType\VehicleRentalDetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->VehRentalDetails) && count($this->VehRentalDetails) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->VehRentalDetails)), __LINE__);
        }
        $this->VehRentalDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Vehicle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
