<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehType StructType
 * Meta information extracted from the WSDL
 * - documentation: Type of vehicle, for example, truck, car
 * @subpackage Structs
 */
class VehType extends AbstractStructBase
{
    /**
     * The VehicleCategory
     * Meta information extracted from the WSDL
     * - documentation: The VehicleCategory attribute provides the catgeory of a vehicle. Refer to OpenTravel Code List Vehicle Category (VEC). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or
     * 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: required
     * @var string
     */
    public $VehicleCategory;
    /**
     * The DoorCount
     * Meta information extracted from the WSDL
     * - documentation: The number of doors on a vehicle. This may be an exact number or a range, i.e. 2-4. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $DoorCount;
    /**
     * Constructor method for VehType
     * @uses VehType::setVehicleCategory()
     * @uses VehType::setDoorCount()
     * @param string $vehicleCategory
     * @param string $doorCount
     */
    public function __construct($vehicleCategory = null, $doorCount = null)
    {
        $this
            ->setVehicleCategory($vehicleCategory)
            ->setDoorCount($doorCount);
    }
    /**
     * Get VehicleCategory value
     * @return string
     */
    public function getVehicleCategory()
    {
        return $this->VehicleCategory;
    }
    /**
     * Set VehicleCategory value
     * @param string $vehicleCategory
     * @return \StructType\VehType
     */
    public function setVehicleCategory($vehicleCategory = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleCategory) && !is_string($vehicleCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleCategory, true), gettype($vehicleCategory)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($vehicleCategory) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $vehicleCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($vehicleCategory, true)), __LINE__);
        }
        $this->VehicleCategory = $vehicleCategory;
        return $this;
    }
    /**
     * Get DoorCount value
     * @return string|null
     */
    public function getDoorCount()
    {
        return $this->DoorCount;
    }
    /**
     * Set DoorCount value
     * @param string $doorCount
     * @return \StructType\VehType
     */
    public function setDoorCount($doorCount = null)
    {
        // validation for constraint: string
        if (!is_null($doorCount) && !is_string($doorCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doorCount, true), gettype($doorCount)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($doorCount) && mb_strlen($doorCount) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($doorCount)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($doorCount) && mb_strlen($doorCount) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($doorCount)), __LINE__);
        }
        $this->DoorCount = $doorCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
