<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UniqueIDs StructType
 * Meta information extracted from the WSDL
 * - documentation: This identifies the master account number and related information.
 * @subpackage Structs
 */
class UniqueIDs extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifiers for the Event Planner or Coordinator. Can include EP IATA# and other unique IDs such as an Event Planner ID assigned by the receiving system.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\UniqueID_Type[]
     */
    public $UniqueID;
    /**
     * Constructor method for UniqueIDs
     * @uses UniqueIDs::setUniqueID()
     * @param \StructType\UniqueID_Type[] $uniqueID
     */
    public function __construct(array $uniqueID = array())
    {
        $this
            ->setUniqueID($uniqueID);
    }
    /**
     * Get UniqueID value
     * @return \StructType\UniqueID_Type[]|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * This method is responsible for validating the values passed to the setUniqueID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUniqueID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUniqueIDForArrayConstraintsFromSetUniqueID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $uniqueIDsUniqueIDItem) {
            // validation for constraint: itemType
            if (!$uniqueIDsUniqueIDItem instanceof \StructType\UniqueID_Type) {
                $invalidValues[] = is_object($uniqueIDsUniqueIDItem) ? get_class($uniqueIDsUniqueIDItem) : sprintf('%s(%s)', gettype($uniqueIDsUniqueIDItem), var_export($uniqueIDsUniqueIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type[] $uniqueID
     * @return \StructType\UniqueIDs
     */
    public function setUniqueID(array $uniqueID = array())
    {
        // validation for constraint: array
        if ('' !== ($uniqueIDArrayErrorMessage = self::validateUniqueIDForArrayConstraintsFromSetUniqueID($uniqueID))) {
            throw new \InvalidArgumentException($uniqueIDArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($uniqueID) && count($uniqueID) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($uniqueID)), __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Add item to UniqueID value
     * @throws \InvalidArgumentException
     * @param \StructType\UniqueID_Type $item
     * @return \StructType\UniqueIDs
     */
    public function addToUniqueID(\StructType\UniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The UniqueID property can only contain items of type \StructType\UniqueID_Type, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->UniqueID) && count($this->UniqueID) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->UniqueID)), __LINE__);
        }
        $this->UniqueID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UniqueIDs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
