<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UniqueID_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: An identifier used to uniquely reference an object in a system (e.g. an airline reservation reference, customer profile reference, booking confirmation number, or a reference to a previous availability quote).
 * @subpackage Structs
 */
class UniqueID_Type extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: A reference to the type of object defined by the UniqueID element. Refer to OpenTravel Code List Unique ID Type (UIT). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - type: OTA_CodeType
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: A unique identifying value assigned by the creating system. The ID attribute may be used to reference a primary-key value within a database or in a particular implementation. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: required
     * @var string
     */
    public $ID;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: Identifies the company that is associated with the UniqueID.
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $CompanyName;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: URL that identifies the location associated with the record identified by the UniqueID.
     * - type: xs:anyURI
     * - use: optional
     * @var string
     */
    public $URL;
    /**
     * The Instance
     * Meta information extracted from the WSDL
     * - documentation: The identification of a record as it exists at a point in time. An instance is used in update messages where the sender must assure the server that the update sent refers to the most recent modification level of the object being
     * updated. | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $Instance;
    /**
     * The ID_Context
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the source of the identifier (e.g., IATA, ABTA). | Used for Character Strings, length 1 to 32.
     * - base: xs:string
     * - maxLength: 32
     * - minLength: 1
     * - type: StringLength1to32
     * - use: optional
     * @var string
     */
    public $ID_Context;
    /**
     * Constructor method for UniqueID_Type
     * @uses UniqueID_Type::setType()
     * @uses UniqueID_Type::setID()
     * @uses UniqueID_Type::setCompanyName()
     * @uses UniqueID_Type::setURL()
     * @uses UniqueID_Type::setInstance()
     * @uses UniqueID_Type::setID_Context()
     * @param string $type
     * @param string $iD
     * @param \StructType\CompanyNameType $companyName
     * @param string $uRL
     * @param string $instance
     * @param string $iD_Context
     */
    public function __construct($type = null, $iD = null, \StructType\CompanyNameType $companyName = null, $uRL = null, $instance = null, $iD_Context = null)
    {
        $this
            ->setType($type)
            ->setID($iD)
            ->setCompanyName($companyName)
            ->setURL($uRL)
            ->setInstance($instance)
            ->setID_Context($iD_Context);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\UniqueID_Type
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($type) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($type, true)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ID value
     * @return string
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\UniqueID_Type
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($iD) && mb_strlen($iD) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($iD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD) && mb_strlen($iD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return \StructType\CompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \StructType\CompanyNameType $companyName
     * @return \StructType\UniqueID_Type
     */
    public function setCompanyName(\StructType\CompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\UniqueID_Type
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get Instance value
     * @return string|null
     */
    public function getInstance()
    {
        return $this->Instance;
    }
    /**
     * Set Instance value
     * @param string $instance
     * @return \StructType\UniqueID_Type
     */
    public function setInstance($instance = null)
    {
        // validation for constraint: string
        if (!is_null($instance) && !is_string($instance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instance, true), gettype($instance)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($instance) && mb_strlen($instance) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($instance)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($instance) && mb_strlen($instance) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($instance)), __LINE__);
        }
        $this->Instance = $instance;
        return $this;
    }
    /**
     * Get ID_Context value
     * @return string|null
     */
    public function getID_Context()
    {
        return $this->ID_Context;
    }
    /**
     * Set ID_Context value
     * @param string $iD_Context
     * @return \StructType\UniqueID_Type
     */
    public function setID_Context($iD_Context = null)
    {
        // validation for constraint: string
        if (!is_null($iD_Context) && !is_string($iD_Context)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD_Context, true), gettype($iD_Context)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($iD_Context) && mb_strlen($iD_Context) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($iD_Context)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD_Context) && mb_strlen($iD_Context) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD_Context)), __LINE__);
        }
        $this->ID_Context = $iD_Context;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UniqueID_Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
