<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerRefNumber StructType
 * Meta information extracted from the WSDL
 * - documentation: One or more travelers to whom this request applies. | Contains the RPH reference to the traveler. | One or more travelers to whom this request applies | Direct reference of traveler assigned by requesting system. Used as a cross
 * reference between data segments.
 * @subpackage Structs
 */
class TravelerRefNumber extends AbstractStructBase
{
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique reference for the traveler. | The Reference Place Holder (RPH) is an index code used to identify an instance in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - type: RPH_Type
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The SurnameRefNumber
     * Meta information extracted from the WSDL
     * - documentation: Used to identify and associate travelers with the same surname. | Used for Character Strings, length 1 to 8.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * - type: StringLength1to8
     * - use: optional
     * @var string
     */
    public $SurnameRefNumber;
    /**
     * The RangePosition
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RangePosition;
    /**
     * Constructor method for TravelerRefNumber
     * @uses TravelerRefNumber::setRPH()
     * @uses TravelerRefNumber::setSurnameRefNumber()
     * @uses TravelerRefNumber::setRangePosition()
     * @param string $rPH
     * @param string $surnameRefNumber
     * @param string $rangePosition
     */
    public function __construct($rPH = null, $surnameRefNumber = null, $rangePosition = null)
    {
        $this
            ->setRPH($rPH)
            ->setSurnameRefNumber($surnameRefNumber)
            ->setRangePosition($rangePosition);
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\TravelerRefNumber
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($rPH) && !preg_match('/[0-9]{1,8}/', $rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($rPH, true)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get SurnameRefNumber value
     * @return string|null
     */
    public function getSurnameRefNumber()
    {
        return $this->SurnameRefNumber;
    }
    /**
     * Set SurnameRefNumber value
     * @param string $surnameRefNumber
     * @return \StructType\TravelerRefNumber
     */
    public function setSurnameRefNumber($surnameRefNumber = null)
    {
        // validation for constraint: string
        if (!is_null($surnameRefNumber) && !is_string($surnameRefNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surnameRefNumber, true), gettype($surnameRefNumber)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($surnameRefNumber) && mb_strlen($surnameRefNumber) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($surnameRefNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($surnameRefNumber) && mb_strlen($surnameRefNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($surnameRefNumber)), __LINE__);
        }
        $this->SurnameRefNumber = $surnameRefNumber;
        return $this;
    }
    /**
     * Get RangePosition value
     * @return string|null
     */
    public function getRangePosition()
    {
        return $this->RangePosition;
    }
    /**
     * Set RangePosition value
     * @param string $rangePosition
     * @return \StructType\TravelerRefNumber
     */
    public function setRangePosition($rangePosition = null)
    {
        // validation for constraint: string
        if (!is_null($rangePosition) && !is_string($rangePosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rangePosition, true), gettype($rangePosition)), __LINE__);
        }
        $this->RangePosition = $rangePosition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelerRefNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
