<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies passenger(s) who will travel on the reservation.
 * @subpackage Structs
 */
class TravelerInfoType extends AbstractStructBase
{
    /**
     * The AirTraveler
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\AirTraveler[]
     */
    public $AirTraveler;
    /**
     * The SpecialReqDetails
     * Meta information extracted from the WSDL
     * - documentation: Provides detailed information regarding any special needs, requests, or remarks associated with the traveler
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpecialReqDetailsType[]
     */
    public $SpecialReqDetails;
    /**
     * Constructor method for TravelerInfoType
     * @uses TravelerInfoType::setAirTraveler()
     * @uses TravelerInfoType::setSpecialReqDetails()
     * @param \StructType\AirTraveler[] $airTraveler
     * @param \StructType\SpecialReqDetailsType[] $specialReqDetails
     */
    public function __construct(array $airTraveler = array(), array $specialReqDetails = array())
    {
        $this
            ->setAirTraveler($airTraveler)
            ->setSpecialReqDetails($specialReqDetails);
    }
    /**
     * Get AirTraveler value
     * @return \StructType\AirTraveler[]|null
     */
    public function getAirTraveler()
    {
        return $this->AirTraveler;
    }
    /**
     * This method is responsible for validating the values passed to the setAirTraveler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirTraveler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirTravelerForArrayConstraintsFromSetAirTraveler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelerInfoTypeAirTravelerItem) {
            // validation for constraint: itemType
            if (!$travelerInfoTypeAirTravelerItem instanceof \StructType\AirTraveler) {
                $invalidValues[] = is_object($travelerInfoTypeAirTravelerItem) ? get_class($travelerInfoTypeAirTravelerItem) : sprintf('%s(%s)', gettype($travelerInfoTypeAirTravelerItem), var_export($travelerInfoTypeAirTravelerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirTraveler property can only contain items of type \StructType\AirTraveler, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirTraveler value
     * @throws \InvalidArgumentException
     * @param \StructType\AirTraveler[] $airTraveler
     * @return \StructType\TravelerInfoType
     */
    public function setAirTraveler(array $airTraveler = array())
    {
        // validation for constraint: array
        if ('' !== ($airTravelerArrayErrorMessage = self::validateAirTravelerForArrayConstraintsFromSetAirTraveler($airTraveler))) {
            throw new \InvalidArgumentException($airTravelerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($airTraveler) && count($airTraveler) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($airTraveler)), __LINE__);
        }
        $this->AirTraveler = $airTraveler;
        return $this;
    }
    /**
     * Add item to AirTraveler value
     * @throws \InvalidArgumentException
     * @param \StructType\AirTraveler $item
     * @return \StructType\TravelerInfoType
     */
    public function addToAirTraveler(\StructType\AirTraveler $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirTraveler) {
            throw new \InvalidArgumentException(sprintf('The AirTraveler property can only contain items of type \StructType\AirTraveler, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AirTraveler) && count($this->AirTraveler) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AirTraveler)), __LINE__);
        }
        $this->AirTraveler[] = $item;
        return $this;
    }
    /**
     * Get SpecialReqDetails value
     * @return \StructType\SpecialReqDetailsType[]|null
     */
    public function getSpecialReqDetails()
    {
        return $this->SpecialReqDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialReqDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialReqDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialReqDetailsForArrayConstraintsFromSetSpecialReqDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelerInfoTypeSpecialReqDetailsItem) {
            // validation for constraint: itemType
            if (!$travelerInfoTypeSpecialReqDetailsItem instanceof \StructType\SpecialReqDetailsType) {
                $invalidValues[] = is_object($travelerInfoTypeSpecialReqDetailsItem) ? get_class($travelerInfoTypeSpecialReqDetailsItem) : sprintf('%s(%s)', gettype($travelerInfoTypeSpecialReqDetailsItem), var_export($travelerInfoTypeSpecialReqDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialReqDetails property can only contain items of type \StructType\SpecialReqDetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialReqDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialReqDetailsType[] $specialReqDetails
     * @return \StructType\TravelerInfoType
     */
    public function setSpecialReqDetails(array $specialReqDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($specialReqDetailsArrayErrorMessage = self::validateSpecialReqDetailsForArrayConstraintsFromSetSpecialReqDetails($specialReqDetails))) {
            throw new \InvalidArgumentException($specialReqDetailsArrayErrorMessage, __LINE__);
        }
        $this->SpecialReqDetails = $specialReqDetails;
        return $this;
    }
    /**
     * Add item to SpecialReqDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialReqDetailsType $item
     * @return \StructType\TravelerInfoType
     */
    public function addToSpecialReqDetails(\StructType\SpecialReqDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialReqDetailsType) {
            throw new \InvalidArgumentException(sprintf('The SpecialReqDetails property can only contain items of type \StructType\SpecialReqDetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialReqDetails[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelerInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
