<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelerInfoSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specify passenger numbers and types
 * @subpackage Structs
 */
class TravelerInfoSummaryType extends AbstractStructBase
{
    /**
     * The SeatsRequested
     * Meta information extracted from the WSDL
     * - documentation: Number of seats requested.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var int[]
     */
    public $SeatsRequested;
    /**
     * The AirTravelerAvail
     * Meta information extracted from the WSDL
     * - documentation: Specifies passenger numbers and types.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\TravelerInformationType[]
     */
    public $AirTravelerAvail;
    /**
     * The PriceRequestInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceRequestInformation
     */
    public $PriceRequestInformation;
    /**
     * Constructor method for TravelerInfoSummaryType
     * @uses TravelerInfoSummaryType::setSeatsRequested()
     * @uses TravelerInfoSummaryType::setAirTravelerAvail()
     * @uses TravelerInfoSummaryType::setPriceRequestInformation()
     * @param int[] $seatsRequested
     * @param \StructType\TravelerInformationType[] $airTravelerAvail
     * @param \StructType\PriceRequestInformation $priceRequestInformation
     */
    public function __construct(array $seatsRequested = array(), array $airTravelerAvail = array(), \StructType\PriceRequestInformation $priceRequestInformation = null)
    {
        $this
            ->setSeatsRequested($seatsRequested)
            ->setAirTravelerAvail($airTravelerAvail)
            ->setPriceRequestInformation($priceRequestInformation);
    }
    /**
     * Get SeatsRequested value
     * @return int[]|null
     */
    public function getSeatsRequested()
    {
        return $this->SeatsRequested;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatsRequested method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatsRequested method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatsRequestedForArrayConstraintsFromSetSeatsRequested(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelerInfoSummaryTypeSeatsRequestedItem) {
            // validation for constraint: itemType
            if (!(is_int($travelerInfoSummaryTypeSeatsRequestedItem) || ctype_digit($travelerInfoSummaryTypeSeatsRequestedItem))) {
                $invalidValues[] = is_object($travelerInfoSummaryTypeSeatsRequestedItem) ? get_class($travelerInfoSummaryTypeSeatsRequestedItem) : sprintf('%s(%s)', gettype($travelerInfoSummaryTypeSeatsRequestedItem), var_export($travelerInfoSummaryTypeSeatsRequestedItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatsRequested property can only contain items of type nonNegativeInteger, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatsRequested value
     * @throws \InvalidArgumentException
     * @param int[] $seatsRequested
     * @return \StructType\TravelerInfoSummaryType
     */
    public function setSeatsRequested(array $seatsRequested = array())
    {
        // validation for constraint: array
        if ('' !== ($seatsRequestedArrayErrorMessage = self::validateSeatsRequestedForArrayConstraintsFromSetSeatsRequested($seatsRequested))) {
            throw new \InvalidArgumentException($seatsRequestedArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($seatsRequested) && count($seatsRequested) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($seatsRequested)), __LINE__);
        }
        $this->SeatsRequested = $seatsRequested;
        return $this;
    }
    /**
     * Add item to SeatsRequested value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\TravelerInfoSummaryType
     */
    public function addToSeatsRequested($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The SeatsRequested property can only contain items of type nonNegativeInteger, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->SeatsRequested) && count($this->SeatsRequested) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->SeatsRequested)), __LINE__);
        }
        $this->SeatsRequested[] = $item;
        return $this;
    }
    /**
     * Get AirTravelerAvail value
     * @return \StructType\TravelerInformationType[]|null
     */
    public function getAirTravelerAvail()
    {
        return $this->AirTravelerAvail;
    }
    /**
     * This method is responsible for validating the values passed to the setAirTravelerAvail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirTravelerAvail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirTravelerAvailForArrayConstraintsFromSetAirTravelerAvail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travelerInfoSummaryTypeAirTravelerAvailItem) {
            // validation for constraint: itemType
            if (!$travelerInfoSummaryTypeAirTravelerAvailItem instanceof \StructType\TravelerInformationType) {
                $invalidValues[] = is_object($travelerInfoSummaryTypeAirTravelerAvailItem) ? get_class($travelerInfoSummaryTypeAirTravelerAvailItem) : sprintf('%s(%s)', gettype($travelerInfoSummaryTypeAirTravelerAvailItem), var_export($travelerInfoSummaryTypeAirTravelerAvailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirTravelerAvail property can only contain items of type \StructType\TravelerInformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirTravelerAvail value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerInformationType[] $airTravelerAvail
     * @return \StructType\TravelerInfoSummaryType
     */
    public function setAirTravelerAvail(array $airTravelerAvail = array())
    {
        // validation for constraint: array
        if ('' !== ($airTravelerAvailArrayErrorMessage = self::validateAirTravelerAvailForArrayConstraintsFromSetAirTravelerAvail($airTravelerAvail))) {
            throw new \InvalidArgumentException($airTravelerAvailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($airTravelerAvail) && count($airTravelerAvail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($airTravelerAvail)), __LINE__);
        }
        $this->AirTravelerAvail = $airTravelerAvail;
        return $this;
    }
    /**
     * Add item to AirTravelerAvail value
     * @throws \InvalidArgumentException
     * @param \StructType\TravelerInformationType $item
     * @return \StructType\TravelerInfoSummaryType
     */
    public function addToAirTravelerAvail(\StructType\TravelerInformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TravelerInformationType) {
            throw new \InvalidArgumentException(sprintf('The AirTravelerAvail property can only contain items of type \StructType\TravelerInformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->AirTravelerAvail) && count($this->AirTravelerAvail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->AirTravelerAvail)), __LINE__);
        }
        $this->AirTravelerAvail[] = $item;
        return $this;
    }
    /**
     * Get PriceRequestInformation value
     * @return \StructType\PriceRequestInformation|null
     */
    public function getPriceRequestInformation()
    {
        return $this->PriceRequestInformation;
    }
    /**
     * Set PriceRequestInformation value
     * @param \StructType\PriceRequestInformation $priceRequestInformation
     * @return \StructType\TravelerInfoSummaryType
     */
    public function setPriceRequestInformation(\StructType\PriceRequestInformation $priceRequestInformation = null)
    {
        $this->PriceRequestInformation = $priceRequestInformation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelerInfoSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
