<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TravelClubType StructType
 * Meta information extracted from the WSDL
 * - documentation: The effective and expiry dates for this travel club membership. | Allows for control of the sharing of travel club data. | Identifies a travel club that offers special privileges and related services.
 * @subpackage Structs
 */
class TravelClubType extends AbstractStructBase
{
    /**
     * The TravelClubName
     * Meta information extracted from the WSDL
     * - documentation: Name of the travel club.
     * @var \StructType\CompanyNameType
     */
    public $TravelClubName;
    /**
     * The ClubMemberName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ClubMemberName
     */
    public $ClubMemberName;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * The ExpireDateExclusiveIndicator
     * @var bool
     */
    public $ExpireDateExclusiveIndicator;
    /**
     * Constructor method for TravelClubType
     * @uses TravelClubType::setTravelClubName()
     * @uses TravelClubType::setClubMemberName()
     * @uses TravelClubType::setShareSynchInd()
     * @uses TravelClubType::setShareMarketInd()
     * @uses TravelClubType::setEffectiveDate()
     * @uses TravelClubType::setExpireDate()
     * @uses TravelClubType::setExpireDateExclusiveIndicator()
     * @param \StructType\CompanyNameType $travelClubName
     * @param \StructType\ClubMemberName $clubMemberName
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param string $effectiveDate
     * @param string $expireDate
     * @param bool $expireDateExclusiveIndicator
     */
    public function __construct(\StructType\CompanyNameType $travelClubName = null, \StructType\ClubMemberName $clubMemberName = null, $shareSynchInd = null, $shareMarketInd = null, $effectiveDate = null, $expireDate = null, $expireDateExclusiveIndicator = null)
    {
        $this
            ->setTravelClubName($travelClubName)
            ->setClubMemberName($clubMemberName)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setExpireDateExclusiveIndicator($expireDateExclusiveIndicator);
    }
    /**
     * Get TravelClubName value
     * @return \StructType\CompanyNameType|null
     */
    public function getTravelClubName()
    {
        return $this->TravelClubName;
    }
    /**
     * Set TravelClubName value
     * @param \StructType\CompanyNameType $travelClubName
     * @return \StructType\TravelClubType
     */
    public function setTravelClubName(\StructType\CompanyNameType $travelClubName = null)
    {
        $this->TravelClubName = $travelClubName;
        return $this;
    }
    /**
     * Get ClubMemberName value
     * @return \StructType\ClubMemberName|null
     */
    public function getClubMemberName()
    {
        return $this->ClubMemberName;
    }
    /**
     * Set ClubMemberName value
     * @param \StructType\ClubMemberName $clubMemberName
     * @return \StructType\TravelClubType
     */
    public function setClubMemberName(\StructType\ClubMemberName $clubMemberName = null)
    {
        $this->ClubMemberName = $clubMemberName;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \StructType\TravelClubType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareSynchInd, true), gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \StructType\TravelClubType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shareMarketInd, true), gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\TravelClubType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\TravelClubType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ExpireDateExclusiveIndicator value
     * @return bool|null
     */
    public function getExpireDateExclusiveIndicator()
    {
        return $this->ExpireDateExclusiveIndicator;
    }
    /**
     * Set ExpireDateExclusiveIndicator value
     * @param bool $expireDateExclusiveIndicator
     * @return \StructType\TravelClubType
     */
    public function setExpireDateExclusiveIndicator($expireDateExclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($expireDateExclusiveIndicator) && !is_bool($expireDateExclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expireDateExclusiveIndicator, true), gettype($expireDateExclusiveIndicator)), __LINE__);
        }
        $this->ExpireDateExclusiveIndicator = $expireDateExclusiveIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TravelClubType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
